/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.config.ProtectionConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Collections;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.World;

public class ClaimCommand
extends AbstractCommand {
    private final ProtectionConfig protectionConfig;
    private final FactionsConfig factionsConfig;

    public ClaimCommand(EagleFactions plugin) {
        super(plugin);
        this.protectionConfig = plugin.getConfiguration().getProtectionConfig();
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFaction = context.getOne((Text)Text.of((String)"faction"));
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        Player player = (Player)source;
        World world = player.getWorld();
        Vector3i chunk = player.getLocation().getChunkPosition();
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        Optional<Faction> optionalChunkFaction = super.getPlugin().getFactionLogic().getFactionByChunk(world.getUniqueId(), chunk);
        boolean hasAdminMode = super.getPlugin().getPlayerManager().hasAdminMode((User)player);
        if (optionalChunkFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.THIS_PLACE_IS_ALREADY_CLAIMED}));
        }
        if (optionalFaction.isPresent()) {
            Faction faction = (Faction)optionalFaction.get();
            return this.preformClaimByFaction(player, faction, chunk);
        }
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction faction = optionalPlayerFaction.get();
        if (hasAdminMode) {
            return this.preformAdminClaim(player, faction, chunk);
        }
        return this.preformNormalClaim(player, faction, chunk);
    }

    private CommandResult preformClaimByFaction(Player player, Faction faction, Vector3i chunk) throws CommandException {
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        boolean hasAdminMode = super.getPlugin().getPlayerManager().hasAdminMode((User)player);
        if (hasAdminMode) {
            return this.preformAdminClaim(player, faction, chunk);
        }
        if (!optionalPlayerFaction.isPresent() || !optionalPlayerFaction.get().getName().equals(faction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_DONT_HAVE_ACCESS_TO_DO_THIS}));
        }
        return this.preformNormalClaim(player, faction, chunk);
    }

    private CommandResult preformAdminClaim(Player player, Faction faction, Vector3i chunk) throws CommandException {
        boolean isCancelled = EventRunner.runFactionClaimEvent(player, faction, player.getWorld(), chunk);
        if (isCancelled) {
            return CommandResult.empty();
        }
        super.getPlugin().getFactionLogic().addClaim(faction, new Claim(player.getWorld().getUniqueId(), chunk));
        player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, Messages.LAND + " ", TextColors.GOLD, chunk.toString(), TextColors.WHITE, " " + Messages.HAS_BEEN_SUCCESSFULLY + " ", TextColors.GOLD, Messages.CLAIMED, TextColors.WHITE, "!"}));
        return CommandResult.success();
    }

    private CommandResult preformNormalClaim(Player player, Faction faction, Vector3i chunk) throws CommandException {
        World world = player.getWorld();
        boolean isClaimableWorld = this.protectionConfig.getClaimableWorldNames().contains(world.getName());
        if (!isClaimableWorld) {
            throw new CommandException(PluginInfo.ERROR_PREFIX.concat(Text.of((Object[])new Object[]{TextColors.RED, Messages.YOU_CANNOT_CLAIM_TERRITORIES_IN_THIS_WORLD})));
        }
        if (!this.getPlugin().getPermsManager().canClaim(player.getUniqueId(), faction)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.PLAYERS_WITH_YOUR_RANK_CANT_CLAIM_LANDS}));
        }
        if (super.getPlugin().getPowerManager().getFactionMaxClaims(faction) <= faction.getClaims().size()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOUR_FACTION_DOES_NOT_HAVE_POWER_TO_CLAIM_MORE_LANDS}));
        }
        if (EagleFactionsPlugin.ATTACKED_FACTIONS.containsKey(faction.getName())) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOUR_FACTION_IS_UNDER_ATTACK + " " + MessageLoader.parseMessage(Messages.YOU_NEED_TO_WAIT_NUMBER_MINUTES_TO_BE_ABLE_TO_CLAIM_AGAIN, Collections.singletonMap(Placeholders.NUMBER, Text.of((Object[])new Object[]{TextColors.GOLD, EagleFactionsPlugin.ATTACKED_FACTIONS.get(faction.getName())})))}));
        }
        if (this.factionsConfig.requireConnectedClaims() && !super.getPlugin().getFactionLogic().isClaimConnected(faction, new Claim(world.getUniqueId(), chunk))) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.CLAIMS_NEED_TO_BE_CONNECTED}));
        }
        boolean isCancelled = EventRunner.runFactionClaimEvent(player, faction, world, chunk);
        if (isCancelled) {
            return CommandResult.empty();
        }
        super.getPlugin().getFactionLogic().startClaiming(player, faction, world.getUniqueId(), chunk);
        return CommandResult.success();
    }
}

