/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.commands;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.commands.AbstractCommand;
import io.github.aquerr.eaglefactions.common.events.EventRunner;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import java.util.Collections;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class ChestCommand
extends AbstractCommand {
    private final FactionsConfig factionsConfig;

    public ChestCommand(EagleFactions plugin) {
        super(plugin);
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
    }

    @Override
    public CommandResult execute(CommandSource source, CommandContext context) throws CommandException {
        Optional optionalFaction = context.getOne("faction");
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ONLY_IN_GAME_PLAYERS_CAN_USE_THIS_COMMAND}));
        }
        if (!this.factionsConfig.canUseFactionChest()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.FACTION_CHESTS_ARE_DISABLED}));
        }
        Player player = (Player)source;
        Optional<Faction> optionalPlayerFaction = super.getPlugin().getFactionLogic().getFactionByPlayerUUID(player.getUniqueId());
        if (optionalFaction.isPresent()) {
            if (optionalPlayerFaction.isPresent() && optionalPlayerFaction.get().getName().equals(((Faction)optionalFaction.get()).getName())) {
                boolean isCancelled = EventRunner.runFactionChestEvent(player, optionalPlayerFaction.get());
                if (isCancelled) {
                    return CommandResult.success();
                }
                this.openFactionChest(player, optionalPlayerFaction.get());
                return CommandResult.success();
            }
            if (!super.getPlugin().getPlayerManager().hasAdminMode((User)player)) {
                throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_NEED_TO_TOGGLE_FACTION_ADMIN_MODE_TO_DO_THIS}));
            }
            Faction faction = (Faction)optionalFaction.get();
            boolean isCancelled = EventRunner.runFactionChestEvent(player, faction);
            if (isCancelled) {
                return CommandResult.success();
            }
            this.openFactionChest(player, faction);
            return CommandResult.success();
        }
        if (!optionalPlayerFaction.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MUST_BE_IN_FACTION_IN_ORDER_TO_USE_THIS_COMMAND}));
        }
        Faction faction = optionalPlayerFaction.get();
        boolean isCancelled = EventRunner.runFactionChestEvent(player, faction);
        if (isCancelled) {
            return CommandResult.success();
        }
        this.openFactionChest(player, faction);
        return CommandResult.success();
    }

    private void openFactionChest(Player player, Faction faction) {
        Optional optionalContainer = player.openInventory(faction.getChest().getInventory());
        if (optionalContainer.isPresent()) {
            player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, MessageLoader.parseMessage(Messages.YOU_OPENED_FACTION_CHEST, Collections.singletonMap(Placeholders.FACTION_NAME, Text.of((Object[])new Object[]{TextColors.GOLD, faction.getName()})))}));
        }
    }
}

