/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandler;
import vswe.superfactory.blocks.ConnectionBlockType;
import vswe.superfactory.components.CommandExecutor;
import vswe.superfactory.components.ComponentMenuContainerScrap;
import vswe.superfactory.components.ComponentMenuCrafting;
import vswe.superfactory.components.internal.CraftingSetting;
import vswe.superfactory.components.internal.FuzzyMode;
import vswe.superfactory.components.internal.IItemBufferElement;
import vswe.superfactory.components.internal.IItemBufferSubElement;
import vswe.superfactory.components.internal.ItemBufferElement;
import vswe.superfactory.components.internal.SideSlotTarget;
import vswe.superfactory.components.internal.SlotInventoryHolder;
import vswe.superfactory.components.internal.SlotStackInventoryHolder;
import vswe.superfactory.tiles.TileEntityManager;

public class CraftingBufferElement
implements IItemBufferElement,
IItemBufferSubElement {
    private static final double SPEED_MULTIPLIER = (double)0.05f;
    private static final Random rand = new Random();
    private List<ItemStack> containerItems;
    private ComponentMenuCrafting craftingMenu;
    private CommandExecutor executor;
    private List<IItemHandler> inventories = new ArrayList<IItemHandler>();
    private boolean isCrafting;
    private boolean justRemoved;
    private int overflowBuffer;
    private IRecipe recipe;
    private ItemStack result;
    private ComponentMenuContainerScrap scrapMenu;

    public CraftingBufferElement(CommandExecutor executor, ComponentMenuCrafting craftingMenu, ComponentMenuContainerScrap scrapMenu) {
        this.executor = executor;
        this.craftingMenu = craftingMenu;
        this.scrapMenu = scrapMenu;
        this.recipe = craftingMenu.getDummy().getRecipe();
        this.result = this.recipe != null ? this.recipe.func_77572_b((InventoryCrafting)craftingMenu.getDummy()) : ItemStack.field_190927_a;
        this.containerItems = new ArrayList<ItemStack>();
    }

    @Override
    public void prepareSubElements() {
        this.isCrafting = true;
        this.justRemoved = false;
    }

    @Override
    public IItemBufferSubElement getSubElement() {
        if (this.isCrafting && !this.result.func_190926_b()) {
            this.isCrafting = false;
            return this;
        }
        return null;
    }

    @Override
    public void removeSubElement() {
    }

    @Override
    public int retrieveItemCount(int moveCount) {
        return moveCount;
    }

    @Override
    public void decreaseStackSize(int moveCount) {
    }

    @Override
    public void releaseSubElements() {
        if (!this.result.func_190926_b()) {
            if (this.overflowBuffer > 0) {
                ItemStack overflow = this.result.func_77946_l();
                overflow.func_190920_e(this.overflowBuffer);
                this.disposeOfExtraItem(overflow);
                this.overflowBuffer = 0;
            }
            for (ItemStack containerItem : this.containerItems) {
                this.disposeOfExtraItem(containerItem);
            }
            this.containerItems.clear();
        }
    }

    private void disposeOfExtraItem(ItemStack itemStack) {
        TileEntityManager manager = this.craftingMenu.getParent().getManager();
        List<SlotInventoryHolder> inventories = CommandExecutor.getContainers(manager, this.scrapMenu, ConnectionBlockType.INVENTORY);
        for (SlotInventoryHolder inventoryHolder : inventories) {
            ArrayList<SideSlotTarget> targets = new ArrayList<SideSlotTarget>();
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                SideSlotTarget target = new SideSlotTarget(enumFacing);
                IItemHandler inventory = inventoryHolder.getInventory(enumFacing);
                if (inventory == null) continue;
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    target.addSlot(i);
                }
                targets.add(target);
            }
            for (SideSlotTarget sideSlotTarget : targets) {
                IItemHandler inventory = inventoryHolder.getInventory(sideSlotTarget.getSide());
                if (inventory == null) continue;
                for (int slot : sideSlotTarget.getSlots()) {
                    int itemCountInSlot;
                    ItemStack itemInSlot;
                    if (inventory.insertItem(slot, itemStack, true) == itemStack || !(itemInSlot = inventory.getStackInSlot(slot)).func_190926_b() && (!itemInSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemInSlot) || !itemStack.func_77985_e())) continue;
                    int n = itemCountInSlot = itemInSlot.func_190926_b() ? 0 : itemInSlot.func_190916_E();
                    int moveCount = Math.min(itemStack.func_190916_E(), Math.min(inventory.getSlotLimit(slot), itemStack.func_77976_d()) - itemCountInSlot);
                    if (moveCount <= 0) continue;
                    ItemStack toInsert = itemStack.func_77946_l();
                    toInsert.func_190920_e(moveCount);
                    inventory.insertItem(slot, toInsert, false);
                    itemStack.func_190918_g(moveCount);
                    if (itemStack.func_190916_E() != 0) continue;
                    return;
                }
            }
        }
        double spawnX = (double)manager.func_174877_v().func_177958_n() + rand.nextDouble() * 0.8 + 0.1;
        double spawnY = (double)manager.func_174877_v().func_177956_o() + rand.nextDouble() * 0.3 + 1.1;
        double spawnZ = (double)manager.func_174877_v().func_177952_p() + rand.nextDouble() * 0.8 + 0.1;
        EntityItem entityItem = new EntityItem(manager.func_145831_w(), spawnX, spawnY, spawnZ, itemStack);
        entityItem.field_70159_w = rand.nextGaussian() * (double)0.05f;
        entityItem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
        entityItem.field_70179_y = rand.nextGaussian() * (double)0.05f;
        manager.func_145831_w().func_72838_d((Entity)entityItem);
    }

    @Override
    public void remove() {
    }

    @Override
    public void onUpdate() {
        this.inventories.clear();
    }

    @Override
    public int getSizeRemaining() {
        if (!this.justRemoved) {
            return this.overflowBuffer > 0 ? this.overflowBuffer : (this.findItems(false) ? this.result.func_190916_E() : 0);
        }
        this.justRemoved = false;
        return 0;
    }

    @Override
    public void reduceAmount(int amount) {
        this.justRemoved = true;
        if (this.overflowBuffer > 0) {
            this.overflowBuffer -= amount;
        } else {
            this.findItems(true);
            this.overflowBuffer = this.result.func_190916_E() - amount;
        }
        this.isCrafting = true;
    }

    @Override
    public ItemStack getItemStack() {
        if (this.useAdvancedDetection()) {
            this.findItems(false);
        }
        return this.result;
    }

    private boolean findItems(boolean remove) {
        HashMap<Integer, ItemStack> foundItems = new HashMap<Integer, ItemStack>();
        for (ItemBufferElement itemBufferElement : this.executor.itemBuffer) {
            int count = itemBufferElement.retrieveItemCount(9);
            Iterator<SlotStackInventoryHolder> iterator = itemBufferElement.getSubElements().iterator();
            while (iterator.hasNext()) {
                IItemBufferSubElement itemBufferSubElement = iterator.next();
                ItemStack itemstack = itemBufferSubElement.getItemStack();
                int subCount = Math.min(count, itemBufferSubElement.getSizeRemaining());
                for (int i = 0; i < 9; ++i) {
                    CraftingSetting setting = (CraftingSetting)this.craftingMenu.getSettings().get(i);
                    if (!foundItems.getOrDefault(i, ItemStack.field_190927_a).func_190926_b()) continue;
                    if (!setting.isValid()) {
                        foundItems.put(i, ItemStack.field_190927_a);
                        continue;
                    }
                    if (subCount <= 0 || !setting.isEqualForCommandExecutor(itemstack)) continue;
                    foundItems.put(i, itemstack.func_77946_l());
                    if (this.craftingMenu.getDummy().isItemValidForRecipe(this.recipe, this.craftingMenu.getResultItem(), foundItems, this.useAdvancedDetection())) {
                        --subCount;
                        --count;
                        if (!remove) continue;
                        if (itemstack.func_77973_b().hasContainerItem(itemstack)) {
                            this.containerItems.add(itemstack.func_77973_b().getContainerItem(itemstack));
                        }
                        itemBufferElement.decreaseStackSize(1);
                        itemBufferSubElement.reduceAmount(1);
                        if (itemBufferSubElement.getSizeRemaining() == 0) {
                            itemBufferSubElement.remove();
                            iterator.remove();
                        }
                        this.inventories.add(((SlotStackInventoryHolder)itemBufferSubElement).getInventory());
                        continue;
                    }
                    foundItems.remove(i);
                }
            }
        }
        if (foundItems.size() == 9) {
            this.result = this.craftingMenu.getDummy().getResult(foundItems);
            this.result = !this.result.func_190926_b() ? this.result.func_77946_l() : ItemStack.field_190927_a;
            return true;
        }
        return false;
    }

    private boolean useAdvancedDetection() {
        return this.craftingMenu.getResultItem().getFuzzyMode() != FuzzyMode.PRECISE;
    }

    public String toString() {
        return "result=" + this.result + ", sizeRemaining=" + this.getSizeRemaining() + ", isCrafting=" + this.isCrafting + ", justRemoved=" + this.justRemoved;
    }
}

