/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerList;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.squiddev.plethora.api.IAttachable;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.gameplay.Plethora;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.gameplay.modules.ChatMessage;
import org.squiddev.plethora.gameplay.registry.Registration;
import org.squiddev.plethora.utils.Helpers;
import org.squiddev.plethora.utils.LuaPattern;

@Mod.EventBusSubscriber(modid="plethora")
public final class ChatListener {
    private static Set<Listener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    private ChatListener() {
    }

    @SubscribeEvent
    public static void onServerChat(ServerChatEvent event) {
        EntityPlayerMP sender = event.getPlayer();
        if (sender instanceof PlethoraFakePlayer) {
            Entity owner = ((PlethoraFakePlayer)sender).getOwner();
            sender = owner == null ? sender : owner;
        }
        for (Listener listener : listeners) {
            if (!listener.handles((Entity)sender) || !listener.handleCapture((Entity)sender, event.getMessage())) continue;
            event.setCanceled(true);
            return;
        }
        for (Listener listener : listeners) {
            listener.handleMessage((Entity)sender, event.getMessage());
        }
        PlayerList players = event.getPlayer().field_71133_b.func_184103_al();
        int distance = players.func_72395_o() * 16;
        distance *= distance;
        ChatMessage message = new ChatMessage((Entity)sender, event.getComponent());
        for (EntityPlayerMP player : players.func_181057_v()) {
            if (!Helpers.isHolding((EntityLivingBase)player, Registration.itemModule, 5) && !Helpers.isHolding((EntityLivingBase)player, Registration.itemModule, 7) || player == sender || player.func_130014_f_() != sender.func_130014_f_() || !(player.func_70068_e((Entity)sender) <= (double)distance)) continue;
            Plethora.network.sendTo((IMessage)message, player);
        }
    }

    public static class CreativeListener
    extends Listener {
        public CreativeListener(@Nonnull IModuleAccess access) {
            super(access, null);
        }

        @Override
        public boolean handles(Entity sender) {
            return true;
        }
    }

    public static class Listener
    implements IAttachable,
    ConstantReference<Listener> {
        private final IModuleAccess access;
        private final UUID owner;
        private final Set<String> patterns = new HashSet<String>();

        public Listener(@Nonnull IModuleAccess access, @Nullable UUID owner) {
            this.access = access;
            this.owner = owner;
        }

        public boolean handles(Entity sender) {
            return this.owner != null && this.owner.equals(sender.func_110124_au());
        }

        public synchronized void addPattern(String pattern) {
            this.patterns.add(pattern);
        }

        public synchronized boolean removePattern(String pattern) {
            return this.patterns.remove(pattern);
        }

        public synchronized void clearPatterns() {
            this.patterns.clear();
        }

        private synchronized boolean handleCapture(Entity sender, String message) {
            for (String pattern : this.patterns) {
                if (!LuaPattern.matches(message, pattern)) continue;
                this.access.queueEvent("chat_capture", message, pattern, sender.func_145748_c_().func_150260_c(), sender.getPersistentID().toString());
                return true;
            }
            return false;
        }

        private void handleMessage(Entity sender, String message) {
            this.access.queueEvent("chat_message", sender.func_145748_c_().func_150260_c(), message, sender.getPersistentID().toString());
        }

        @Override
        public void attach() {
            listeners.add(this);
        }

        @Override
        public void detach() {
            listeners.remove(this);
        }

        @Override
        @Nonnull
        public Listener get() {
            return this;
        }

        @Override
        @Nonnull
        public Listener safeGet() {
            return this;
        }
    }
}

