/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.EntityWorldLocation;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.CostHelpers;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.module.SingletonModuleContainer;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.api.vehicle.IVehicleAccess;
import org.squiddev.plethora.api.vehicle.IVehicleUpgradeHandler;
import org.squiddev.plethora.core.AttachableWrapperPeripheral;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.MethodWrapperPeripheral;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.executor.TaskRunner;

public class VehicleUpgradeModule
implements IVehicleUpgradeHandler {
    private final IModuleHandler handler;

    public VehicleUpgradeModule(IModuleHandler handler) {
        this.handler = handler;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(@Nonnull IVehicleAccess access) {
        Pair<IBakedModel, Matrix4f> model = this.handler.getModel(0.0f);
        Matrix4f transform = new Matrix4f();
        transform.setIdentity();
        transform.setTranslation(new Vector3f(0.0f, 0.0f, -0.46875f));
        transform.mul(transform, (Matrix4f)model.getRight());
        return Pair.of((Object)model.getLeft(), (Object)transform);
    }

    @Override
    public void update(@Nonnull IVehicleAccess vehicle, @Nonnull IPeripheral peripheral) {
        if (peripheral instanceof MethodWrapperPeripheral) {
            ((MethodWrapperPeripheral)peripheral).getRunner().func_73660_a();
        }
    }

    @Override
    @Nullable
    public IPeripheral create(@Nonnull IVehicleAccess vehicle) {
        ResourceLocation thisModule = this.handler.getModule();
        String moduleName = thisModule.toString();
        if (ConfigCore.Blacklist.blacklistModulesVehicle.contains(moduleName) || ConfigCore.Blacklist.blacklistModules.contains(moduleName)) {
            return null;
        }
        MethodRegistry registry = MethodRegistry.instance;
        Entity entity = vehicle.getVehicle();
        ICostHandler cost = CostHelpers.getCostHandler((ICapabilityProvider)entity, null);
        VehicleModuleAccess access = new VehicleModuleAccess(vehicle, this.handler);
        final IModuleContainer container = access.getContainer();
        ConstantReference<IModuleContainer> containerRef = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() {
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() {
                return this.get();
            }
        };
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef).withCostHandler(cost)).withModules(container, containerRef)).addContext("origin", new EntityWorldLocation(entity))).addContext("origin", vehicle, (IReference)Reference.id(vehicle))).addContext("origin", vehicle.getVehicle(), (IReference)Reference.entity(vehicle.getVehicle()));
        this.handler.getAdditionalContext(access, (IContextBuilder)((Object)factory));
        Pair<List<IMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        if (((List)paired.getLeft()).isEmpty()) {
            return null;
        }
        AttachableWrapperPeripheral peripheral = new AttachableWrapperPeripheral(moduleName, (Object)this, paired, new TaskRunner(), ((ContextFactory)factory).getAttachments());
        access.wrapper = peripheral;
        return peripheral;
    }

    private static final class VehicleModuleAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final IVehicleAccess access;
        private final IWorldLocation location;
        private final IModuleContainer container;

        private VehicleModuleAccess(IVehicleAccess access, IModuleHandler handler) {
            this.access = access;
            this.location = new EntityWorldLocation(access.getVehicle());
            this.container = new SingletonModuleContainer(handler.getModule());
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.access;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public NBTTagCompound getData() {
            return this.access.getData();
        }

        @Override
        public void markDataDirty() {
            this.access.markDataDirty();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }
}

