/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.method.IResultExecutor;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.core.MethodWrapper;
import org.squiddev.plethora.core.PlethoraCore;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.executor.ComputerAccessExecutor;
import org.squiddev.plethora.core.executor.TaskRunner;

public class MethodWrapperPeripheral
extends MethodWrapper
implements IPeripheral {
    private final Object owner;
    private final String type;
    private final TaskRunner runner;
    private final Map<IComputerAccess, ComputerAccessExecutor> accesses = new ConcurrentHashMap<IComputerAccess, ComputerAccessExecutor>();

    public MethodWrapperPeripheral(String name, Object owner, List<IMethod<?>> methods, List<UnbakedContext<?>> contexts, TaskRunner runner) {
        super(methods, contexts);
        this.owner = owner;
        this.type = name;
        this.runner = runner;
    }

    public MethodWrapperPeripheral(String name, Object owner, Pair<List<IMethod<?>>, List<UnbakedContext<?>>> methods, TaskRunner runner) {
        this(name, owner, (List)methods.getLeft(), (List)methods.getRight(), runner);
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public Object[] callMethod(@Nonnull IComputerAccess access, @Nonnull ILuaContext luaContext, int method, @Nonnull Object[] args) throws LuaException, InterruptedException {
        IResultExecutor executor = this.accesses.get(access);
        if (executor == null) {
            throw new LuaException("Not attached to this computer");
        }
        UnbakedContext<?> context = this.getContext(method);
        Object[] extraRef = MethodWrapperPeripheral.getReferences(access, luaContext);
        int totalSize = context.keys.length + extraRef.length;
        String[] keys = new String[totalSize];
        System.arraycopy(context.keys, 0, keys, 0, context.keys.length);
        Object[] references = new Object[totalSize];
        System.arraycopy(context.references, 0, references, 0, context.references.length);
        for (int i = 0; i < extraRef.length; ++i) {
            keys[context.keys.length + i] = "computer";
            references[context.keys.length + i] = extraRef[i];
        }
        UnbakedContext full = new UnbakedContext(context.target, keys, references, context.handler, context.modules, executor);
        MethodResult result = MethodWrapperPeripheral.doCallMethod(this.getMethod(method), full, args);
        return executor.execute(result, luaContext);
    }

    public void attach(@Nonnull IComputerAccess access) {
        ComputerAccessExecutor executor = new ComputerAccessExecutor(access, this.runner);
        executor.attach();
        ComputerAccessExecutor previous = this.accesses.put(access, executor);
        if (previous != null) {
            previous.detach();
        }
    }

    public void detach(@Nonnull IComputerAccess access) {
        ComputerAccessExecutor executor = this.accesses.remove(access);
        if (executor != null) {
            executor.detach();
        }
    }

    public void queueEvent(@Nonnull String name, Object ... args) {
        for (IComputerAccess access : this.accesses.keySet()) {
            try {
                access.queueEvent(name, args);
            }
            catch (RuntimeException e) {
                PlethoraCore.LOG.error("Cannot queue event on " + access, (Throwable)e);
            }
        }
    }

    @Nonnull
    public TaskRunner getRunner() {
        return this.runner;
    }

    @Nonnull
    public Object getTarget() {
        return this.owner;
    }

    public boolean equals(IPeripheral other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodWrapperPeripheral)) {
            return false;
        }
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        MethodWrapperPeripheral otherP = (MethodWrapperPeripheral)other;
        return this.owner == otherP.owner && this.equalMethods(otherP);
    }
}

