/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.spectreilluminator;

import java.util.HashSet;
import lumien.randomthings.handler.spectreilluminator.SpectreIlluminationHelper;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.PacketHandler;
import lumien.randomthings.network.messages.MessageSpectreIllumination;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldSavedData;

public class SpectreIlluminationHandler
extends WorldSavedData {
    static final String ID = "RTSIH";
    HashSet<Long> illuminatedChunks = new HashSet();

    public SpectreIlluminationHandler() {
        this(ID);
    }

    public SpectreIlluminationHandler(String id) {
        super(id);
    }

    public static SpectreIlluminationHandler get(World worldObj) {
        SpectreIlluminationHandler instance = (SpectreIlluminationHandler)worldObj.getPerWorldStorage().func_75742_a(SpectreIlluminationHandler.class, ID);
        if (instance == null) {
            instance = new SpectreIlluminationHandler();
            worldObj.getPerWorldStorage().func_75745_a(ID, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("illuminatedChunks", 4);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.illuminatedChunks.add(((NBTTagLong)list.func_179238_g(i)).func_150291_c());
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Long cp : this.illuminatedChunks) {
            list.func_74742_a((NBTBase)new NBTTagLong(cp.longValue()));
        }
        compound.func_74782_a("illuminatedChunks", (NBTBase)list);
        return compound;
    }

    public void startWatching(Chunk c, EntityPlayerMP player) {
        long cp = ChunkPos.func_77272_a((int)c.field_76635_g, (int)c.field_76647_h);
        if (this.illuminatedChunks.contains(cp)) {
            MessageSpectreIllumination msg = new MessageSpectreIllumination(c.func_177412_p().field_73011_w.getDimension(), cp, true);
            PacketHandler.INSTANCE.sendTo(msg, player);
        }
    }

    public boolean isIlluminated(BlockPos pos) {
        return this.illuminatedChunks.contains(ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4)));
    }

    public void toggleChunk(World world, BlockPos pos) {
        boolean newValue;
        long cpLong = ChunkPos.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        if (this.illuminatedChunks.contains(cpLong)) {
            this.illuminatedChunks.remove(cpLong);
            newValue = false;
        } else {
            this.illuminatedChunks.add(cpLong);
            newValue = true;
        }
        SpectreIlluminationHelper.lightUpdateChunk(world, new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4));
        MessageSpectreIllumination msg = new MessageSpectreIllumination(world.field_73011_w.getDimension(), cpLong, newValue);
        MessageUtil.sendToAllWatchingPos(world, pos, msg);
        world.func_175646_b(pos, null);
        this.func_76185_a();
    }
}

