/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.block;

import java.util.Random;
import javax.annotation.Nullable;
import lumien.randomthings.block.BlockBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBlazingFire
extends BlockBase {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)15);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UPPER = PropertyBool.func_177716_a((String)"up");

    public BlockBlazingFire() {
        super("blazingFire", Material.field_151581_o);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149649_H();
        this.func_149711_c(0.0f).func_149715_a(1.0f);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid(worldIn, pos.func_177977_b(), EnumFacing.UP) && !Blocks.field_150480_ab.canCatchFire(worldIn, pos.func_177977_b(), EnumFacing.UP)) {
            return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177974_f(), EnumFacing.WEST))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177976_e(), EnumFacing.EAST))).func_177226_a((IProperty)UPPER, (Comparable)Boolean.valueOf(this.canCatchFire(worldIn, pos.func_177984_a(), EnumFacing.DOWN)));
        }
        return this.func_176223_P();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public int func_149738_a(World worldIn) {
        return 15;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.func_82736_K().func_82766_b("doFireTick")) {
            if (!this.func_176196_c(worldIn, pos)) {
                worldIn.func_175698_g(pos);
            }
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            boolean flag = block.isFireSource(worldIn, pos.func_177977_b(), EnumFacing.UP);
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            if (!flag && worldIn.func_72896_J() && this.canDie(worldIn, pos) && rand.nextFloat() < 0.2f + (float)i * 0.03f) {
                worldIn.func_175698_g(pos);
            } else {
                if (i < 15) {
                    state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.min(15, i + rand.nextInt(3) / 2)));
                    worldIn.func_180501_a(pos, state, 4);
                }
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + rand.nextInt(10));
                if (!flag) {
                    if (!this.canNeighborCatchFire(worldIn, pos)) {
                        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || i > 3) {
                            worldIn.func_175698_g(pos);
                        }
                        return;
                    }
                    if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && i == 15 && rand.nextInt(4) == 0) {
                        worldIn.func_175698_g(pos);
                        return;
                    }
                }
                boolean flag1 = worldIn.func_180502_D(pos);
                int j = 0;
                if (flag1) {
                    j = -50;
                }
                this.tryCatchFire(worldIn, pos.func_177974_f(), 300 + j, rand, i, EnumFacing.WEST);
                this.tryCatchFire(worldIn, pos.func_177976_e(), 300 + j, rand, i, EnumFacing.EAST);
                this.tryCatchFire(worldIn, pos.func_177977_b(), 250 + j, rand, i, EnumFacing.UP);
                this.tryCatchFire(worldIn, pos.func_177984_a(), 250 + j, rand, i, EnumFacing.DOWN);
                this.tryCatchFire(worldIn, pos.func_177978_c(), 300 + j, rand, i, EnumFacing.SOUTH);
                this.tryCatchFire(worldIn, pos.func_177968_d(), 300 + j, rand, i, EnumFacing.NORTH);
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 4; ++i1) {
                            BlockPos blockpos;
                            int k1;
                            if (k == 0 && i1 == 0 && l == 0) continue;
                            int j1 = 100;
                            if (i1 > 1) {
                                j1 += (i1 - 1) * 100;
                            }
                            if ((k1 = this.getNeighborEncouragement(worldIn, blockpos = pos.func_177982_a(k, i1, l))) <= 0) continue;
                            int l1 = (k1 + 40 + worldIn.func_175659_aa().func_151525_a() * 7) / (i + 30);
                            if (flag1) {
                                l1 /= 2;
                            }
                            if (l1 <= 0 || rand.nextInt(j1) > l1 || worldIn.func_72896_J() && this.canDie(worldIn, blockpos)) continue;
                            int i2 = i + rand.nextInt(5) / 4;
                            if (i2 > 15) {
                                i2 = 15;
                            }
                            worldIn.func_180501_a(blockpos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(i2)), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean canDie(World worldIn, BlockPos pos) {
        return worldIn.func_175727_C(pos) || worldIn.func_175727_C(pos.func_177976_e()) || worldIn.func_175727_C(pos.func_177974_f()) || worldIn.func_175727_C(pos.func_177978_c()) || worldIn.func_175727_C(pos.func_177968_d());
    }

    public boolean func_149698_L() {
        return false;
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, EnumFacing face) {
        int i = worldIn.func_180495_p(pos).func_177230_c().getFlammability((IBlockAccess)worldIn, pos, face);
        if (random.nextInt(chance) < i * 4) {
            IBlockState iblockstate = worldIn.func_180495_p(pos);
            if (random.nextInt(age / 2 + 1) < 5 && !worldIn.func_175727_C(pos)) {
                int j = age + random.nextInt(2);
                if (j > 15) {
                    j = 15;
                }
                worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j)), 3);
            } else {
                worldIn.func_175698_g(pos);
            }
            if (iblockstate.func_177230_c() == Blocks.field_150335_W) {
                Blocks.field_150335_W.func_176206_d(worldIn, pos, iblockstate.func_177226_a((IProperty)BlockTNT.field_176246_a, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    private boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c().getFireSpreadSpeed((IBlockAccess)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d()), i);
        }
        return i;
    }

    public boolean func_149703_v() {
        return false;
    }

    @Deprecated
    public boolean canCatchFire(IBlockAccess worldIn, BlockPos pos) {
        return this.canCatchFire(worldIn, pos, EnumFacing.UP);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || this.canNeighborCatchFire(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos changedPos) {
        if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && !this.canNeighborCatchFire(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_73011_w.func_186058_p().func_186068_a() > 0 || !Blocks.field_150427_aO.func_176548_d(worldIn, pos)) {
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && !this.canNeighborCatchFire(worldIn, pos)) {
                worldIn.func_175698_g(pos);
            } else {
                worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn) + worldIn.field_73012_v.nextInt(10));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        block12: {
            block11: {
                if (rand.nextInt(24) == 0) {
                    worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
                }
                if (worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) || Blocks.field_150480_ab.canCatchFire((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) break block11;
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)worldIn, pos.func_177976_e(), EnumFacing.EAST)) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)pos.func_177958_n() + rand.nextDouble() * (double)0.1f;
                        double d8 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d13 = (double)pos.func_177952_p() + rand.nextDouble();
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)worldIn, pos.func_177974_f(), EnumFacing.WEST)) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(pos.func_177958_n() + 1) - rand.nextDouble() * (double)0.1f;
                        double d9 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d14 = (double)pos.func_177952_p() + rand.nextDouble();
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d4, d9, d14, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)worldIn, pos.func_177978_c(), EnumFacing.SOUTH)) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d10 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d15 = (double)pos.func_177952_p() + rand.nextDouble() * (double)0.1f;
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d5, d10, d15, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.field_150480_ab.canCatchFire((IBlockAccess)worldIn, pos.func_177968_d(), EnumFacing.NORTH)) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)pos.func_177958_n() + rand.nextDouble();
                        double d11 = (double)pos.func_177956_o() + rand.nextDouble();
                        double d16 = (double)(pos.func_177952_p() + 1) - rand.nextDouble() * (double)0.1f;
                        worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d6, d11, d16, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (!Blocks.field_150480_ab.canCatchFire((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN)) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)pos.func_177958_n() + rand.nextDouble();
                    double d12 = (double)(pos.func_177956_o() + 1) - rand.nextDouble() * (double)0.1f;
                    double d17 = (double)pos.func_177952_p() + rand.nextDouble();
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d7, d12, d17, 0.0, 0.0, 0.0, new int[0]);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)pos.func_177958_n() + rand.nextDouble();
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 0.5 + 0.5;
                double d2 = (double)pos.func_177952_p() + rand.nextDouble();
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess p_180659_2_, BlockPos p_180659_3_) {
        return MapColor.field_151656_f;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean isBurning(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    public boolean canCatchFire(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return world.func_180495_p(pos).func_177230_c().isFlammable(world, pos, face);
    }
}

