/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.listeners;

import com.google.common.collect.Sets;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfig;
import io.github.nucleuspowered.nucleus.modules.world.config.WorldConfigAdapter;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.teleport.TeleportHelperFilter;
import org.spongepowered.api.world.teleport.TeleportHelperFilters;

public class WorldListener
implements ListenerBase.Conditional {
    private final Set<UUID> messageSent = Sets.newHashSet();

    @Listener
    public void onPlayerTeleport(MoveEntityEvent.Teleport event, @Getter(value="getTargetEntity") Player player) {
        World target = (World)event.getToTransform().getExtent();
        if (player.getWorld().equals(target)) {
            return;
        }
        if (!this.hasPermission((Subject)player, "nucleus.worlds." + target.getName().toLowerCase())) {
            event.setCancelled(true);
            if (!this.messageSent.contains(player.getUniqueId())) {
                player.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("world.access.denied", target.getName()));
            }
            if (event instanceof MoveEntityEvent.Teleport.Portal) {
                this.messageSent.add(player.getUniqueId());
                Sponge.getScheduler().createTaskBuilder().delayTicks(1L).execute(this.relocate(player)).submit((Object)Nucleus.getNucleus());
            }
        }
    }

    @Override
    public boolean shouldEnable() {
        return Nucleus.getNucleus().getConfigValue("world", WorldConfigAdapter.class, WorldConfig::isSeparatePermissions).orElse(false);
    }

    private Consumer<Task> relocate(Player player) {
        return task -> {
            Optional location = Sponge.getTeleportHelper().getSafeLocationWithBlacklist(player.getLocation(), 5, 5, 5, new TeleportHelperFilter[]{TeleportHelperFilters.NO_PORTAL});
            if (location.isPresent()) {
                player.setLocation((Location)location.get());
            } else {
                player.setLocationSafely(player.getWorld().getSpawnLocation());
            }
            this.messageSent.remove(player.getUniqueId());
        };
    }
}

