/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@NonnullByDefault
@NoModifiers
@Permissions(prefix="world", suggestedLevel=SuggestedLevel.OWNER)
@RegisterCommand(value={"rename"}, subcommandOf=WorldCommand.class)
public class RenameWorldCommand
extends AbstractCommand<CommandSource> {
    private final String newNameKey = "new name";

    @Override
    protected CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_UNLOADED_ONLY, GenericArguments.string((Text)Text.of((String)this.newNameKey))};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties worldProperties = (WorldProperties)args.getOne("world").get();
        String oldName = worldProperties.getWorldName();
        String newName = (String)args.getOne(this.newNameKey).get();
        if (Sponge.getServer().renameWorld(worldProperties, newName).isPresent()) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.rename.success", oldName, newName));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.world.rename.failed", worldProperties.getWorldName(), newName);
    }
}

