/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.world.commands.CreateWorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world", suggestedLevel=SuggestedLevel.ADMIN)
@RegisterCommand(value={"list", "ls"}, subcommandOf=WorldCommand.class, rootAliasRegister={"worlds"})
@NonnullByDefault
public class ListWorldCommand
extends AbstractCommand<CommandSource> {
    private static final Text SPACE = Text.of((String)" ");

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> m = super.permissionSuffixesToRegister();
        m.put("seed", PermissionInformation.getWithTranslation("permission.world.seed", SuggestedLevel.ADMIN));
        return m;
    }

    static void getWorldInfo(List<Text> listContent, WorldProperties x, boolean canSeeSeeds) {
        Nucleus plugin = Nucleus.getNucleus();
        if (!listContent.isEmpty()) {
            listContent.add(SPACE);
        }
        listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.worlditem", x.getWorldName()));
        x.getAdditionalProperties().getInt(DataQuery.of((String[])new String[]{"SpongeData", "dimensionId"})).ifPresent(i -> listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.dimensionid", String.valueOf(i))));
        Vector3i spawnPosition = x.getSpawnPosition();
        listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.spawnpoint", String.valueOf(spawnPosition.getX()), String.valueOf(spawnPosition.getY()), String.valueOf(spawnPosition.getZ())));
        listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.uuid", x.getUniqueId().toString()));
        if (x.isEnabled()) {
            boolean worldLoaded = Sponge.getServer().getWorld(x.getUniqueId()).isPresent();
            String message = (worldLoaded ? "&a" : "&c") + plugin.getMessageProvider().getMessageWithFormat(worldLoaded ? "standard.true" : "standard.false", new String[0]);
            listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.enabled", message));
        } else {
            listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.disabled", new String[0]));
        }
        if (canSeeSeeds) {
            listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.seed", String.valueOf(x.getSeed())));
        }
        listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.params", x.getDimensionType().getName(), x.getGeneratorType().getName(), CreateWorldCommand.modifierString(x.getGeneratorModifiers()), x.getGameMode().getName(), x.getDifficulty().getName()));
        listContent.add(plugin.getMessageProvider().getTextMessageWithFormat("command.world.list.params2", String.valueOf(x.isHardcore()), String.valueOf(x.loadOnStartup()), String.valueOf(x.isPVPEnabled()), String.valueOf(x.doesKeepSpawnLoaded())));
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        Collection cwp = Sponge.getServer().getAllWorldProperties();
        ArrayList listContent = Lists.newArrayList();
        boolean canSeeSeeds = this.permissions.testSuffix((Subject)src, "seed");
        cwp.stream().sorted(Comparator.comparing(WorldProperties::getWorldName)).forEach(x -> ListWorldCommand.getWorldInfo(listContent, x, canSeeSeeds));
        Util.getPaginationBuilder(src).contents((Iterable)listContent).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.list.title", new String[0])).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

