/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.world.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.modules.world.commands.ListWorldCommand;
import io.github.nucleuspowered.nucleus.modules.world.commands.WorldCommand;
import java.util.ArrayList;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@Permissions(prefix="world", mainOverride="list")
@NonnullByDefault
@RegisterCommand(value={"info"}, subcommandOf=WorldCommand.class)
public class InfoWorldCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.WORLD_PROPERTIES_ALL};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        WorldProperties wp = this.getWorldFromUserOrArgs(src, "world", args);
        ArrayList listContent = Lists.newArrayList();
        boolean canSeeSeeds = this.permissions.testSuffix((Subject)src, "seed");
        ListWorldCommand.getWorldInfo(listContent, wp, canSeeSeeds);
        Util.getPaginationBuilder(src).contents((Iterable)listContent).title(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.world.info.title", wp.getWorldName())).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

