/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.message.services.MessageHandler;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@RunAsync
@NoModifiers
@RegisterCommand(value={"socialspy"})
@EssentialsEquivalent(value={"socialspy"})
@NonnullByDefault
public class SocialSpyCommand
extends AbstractCommand<Player> {
    private final MessageHandler handler = (MessageHandler)this.getServiceUnchecked(MessageHandler.class);

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        return new HashMap<String, PermissionInformation>(){
            {
                this.put("force", PermissionInformation.getWithTranslation("permission.socialspy.force", SuggestedLevel.NONE));
            }
        };
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        if (this.handler.forcedSocialSpyState((User)src).asBoolean()) {
            throw new ReturnMessageException(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.socialspy.forced", new String[0]));
        }
        boolean spy = args.getOne("true|false").orElse(!this.handler.isSocialSpy((User)src));
        if (this.handler.setSocialSpy((User)src, spy)) {
            Text message = Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat(spy ? "command.socialspy.on" : "command.socialspy.off", new String[0]);
            src.sendMessage(message);
            return CommandResult.success();
        }
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.socialspy.unable", new String[0]));
        return CommandResult.empty();
    }
}

