/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mail.services;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.NucleusPlugin;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.MailMessage;
import io.github.nucleuspowered.nucleus.api.service.NucleusMailService;
import io.github.nucleuspowered.nucleus.internal.annotations.APIService;
import io.github.nucleuspowered.nucleus.internal.interfaces.ServiceBase;
import io.github.nucleuspowered.nucleus.modules.mail.data.MailData;
import io.github.nucleuspowered.nucleus.modules.mail.datamodules.MailUserDataModule;
import io.github.nucleuspowered.nucleus.modules.mail.events.InternalNucleusMailEvent;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;

@APIService(value=NucleusMailService.class)
public class MailHandler
implements NucleusMailService,
ServiceBase {
    @Override
    public final List<MailMessage> getMail(User player, NucleusMailService.MailFilter ... filters) {
        return Lists.newArrayList(this.getMailInternal(player, filters));
    }

    public final List<MailData> getMailInternal(User player, NucleusMailService.MailFilter ... filters) {
        MailUserDataModule iqsu = Nucleus.getNucleus().getUserDataManager().getUnchecked(player).get(MailUserDataModule.class);
        List<MailData> lmd = iqsu.getMail();
        if (filters.length == 0 || lmd.isEmpty()) {
            return Lists.newArrayList(lmd);
        }
        Optional<Predicate> lmf = Arrays.stream(filters).map(x -> x).reduce(Predicate::and);
        return lmf.map(pred -> lmd.stream().filter(pred::test).collect(Collectors.toList())).orElse(lmd);
    }

    @Override
    public boolean removeMail(User player, MailMessage mailData) {
        try {
            return Nucleus.getNucleus().getUserDataManager().getUnchecked(player).get(MailUserDataModule.class).removeMail(mailData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void sendMail(User playerFrom, User playerTo, String message) {
        MailUserDataModule iqsu;
        try {
            iqsu = Nucleus.getNucleus().getUserDataManager().getUnchecked(playerTo).get(MailUserDataModule.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (Sponge.getEventManager().post((Event)new InternalNucleusMailEvent(playerFrom, playerTo, message))) {
            playerFrom.getPlayer().ifPresent(x -> x.sendMessage(NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("message.cancel", new String[0])));
            return;
        }
        MailData md = new MailData(playerFrom == null ? Util.consoleFakeUUID : playerFrom.getUniqueId(), Instant.now(), message);
        iqsu.addMail(md);
        LiteralText from = playerFrom == null ? Text.of((String)Sponge.getServer().getConsole().getName()) : Nucleus.getNucleus().getNameUtil().getName(playerFrom);
        playerTo.getPlayer().ifPresent(arg_0 -> MailHandler.lambda$sendMail$3((Text)from, arg_0));
    }

    @Override
    public void sendMailFromConsole(User playerTo, String message) {
        this.sendMail(null, playerTo, message);
    }

    @Override
    public boolean clearUserMail(User player) {
        MailUserDataModule iqsu;
        try {
            iqsu = Nucleus.getNucleus().getUserDataManager().get(player).get().get(MailUserDataModule.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return iqsu.clearMail();
    }

    private static /* synthetic */ void lambda$sendMail$3(Text from, Player x) {
        x.sendMessage(Text.builder().append(new Text[]{NucleusPlugin.getNucleus().getMessageProvider().getTextMessageWithFormat("mail.youvegotmail", new String[0])}).append(new Text[]{Text.of((Object[])new Object[]{" ", from})}).build());
    }
}

