/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jump.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.internal.teleport.NucleusTeleportHandler;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfig;
import io.github.nucleuspowered.nucleus.modules.jump.config.JumpConfigAdapter;
import java.util.Optional;
import java.util.function.Function;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(suggestedLevel=SuggestedLevel.ADMIN)
@NonnullByDefault
@RegisterCommand(value={"unstuck"})
public class UnstuckCommand
extends AbstractCommand<Player>
implements Reloadable {
    private int radius = 1;
    private int height = 1;

    @Override
    protected CommandResult executeCommand(Player src, CommandContext args, Cause cause) throws Exception {
        Location location = (Location)Sponge.getGame().getTeleportHelper().getSafeLocation(src.getLocation(), this.height, this.radius).orElseThrow(() -> ReturnMessageException.fromKey("command.unstuck.nolocation", new Object[0]));
        if (location.getBlockPosition().equals((Object)src.getLocation().getBlockPosition())) {
            throw ReturnMessageException.fromKey("command.unstuck.notneeded", new Object[0]);
        }
        if (NucleusTeleportHandler.setLocation(src, (Location<World>)location)) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithTextFormat("command.unstuck.success", new Text[0]));
            return CommandResult.success();
        }
        throw ReturnMessageException.fromKey("command.unstuck.cancelled", new Object[0]);
    }

    @Override
    public void onReload() {
        Optional<JumpConfig> c = Nucleus.getNucleus().getConfigValue("jump", JumpConfigAdapter.class, Function.identity());
        this.radius = c.map(JumpConfig::getMaxUnstuckRadius).orElse(1);
        this.height = c.map(JumpConfig::getMaxUnstuckHeight).orElse(1);
    }
}

