/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.jail.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.nucleusdata.NamedLocation;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.messages.MessageProvider;
import io.github.nucleuspowered.nucleus.modules.jail.JailParameters;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions
@RunAsync
@NoModifiers
@RegisterCommand(value={"checkjailed"})
@NonnullByDefault
public class CheckJailedCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{JailParameters.OPTIONAL_JAIL};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        MessageProvider provider = Nucleus.getNucleus().getMessageProvider();
        Optional jail = args.getOne("jail");
        List usersInJail = jail.map(x -> Nucleus.getNucleus().getUserCacheService().getJailedIn(x.getName())).orElseGet(() -> Nucleus.getNucleus().getUserCacheService().getJailed());
        String jailName = jail.map(NamedLocation::getName).orElseGet(() -> provider.getMessageWithFormat("standard.alljails", new String[0]));
        if (usersInJail.isEmpty()) {
            src.sendMessage(provider.getTextMessageWithFormat("command.checkjailed.none", jailName));
            return CommandResult.success();
        }
        Util.getPaginationBuilder(src).title(provider.getTextMessageWithFormat("command.checkjailed.header", jailName)).contents((Iterable)usersInJail.stream().map(x -> {
            Text name = Nucleus.getNucleus().getNameUtil().getName((UUID)x).orElseGet(() -> Text.of((Object[])new Object[]{"unknown: ", x.toString()}));
            return name.toBuilder().onHover((HoverAction)TextActions.showText((Text)provider.getTextMessageWithFormat("command.checkjailed.hover", new String[0]))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:checkjail " + x.toString()))).build();
        }).collect(Collectors.toList())).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

