/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.core.commands.itemalias;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.configurate.datatypes.ItemDataNode;
import io.github.nucleuspowered.nucleus.dataservices.ItemDataService;
import io.github.nucleuspowered.nucleus.internal.annotations.RunAsync;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.modules.core.commands.itemalias.ItemAliasCommand;
import java.util.function.Function;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@RunAsync
@NoModifiers
@Permissions(prefix="nucleus.itemalias")
@RegisterCommand(value={"remove", "del"}, subcommandOf=ItemAliasCommand.class)
@NonnullByDefault
public class RemoveItemAliasCommand
extends AbstractCommand<CommandSource> {
    private final ItemDataService itemDataService = Nucleus.getNucleus().getItemDataService();
    private final String alias = "alias";

    @Override
    public CommandElement[] getArguments() {
        CommandElement[] commandElementArray = new CommandElement[1];
        commandElementArray[0] = GenericArguments.onlyOne((CommandElement)GenericArguments.choices((Text)Text.of((String)this.alias), this.itemDataService::getAliases, Function.identity()));
        return commandElementArray;
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        String al = (String)args.getOne(this.alias).get();
        String id = this.itemDataService.getIdFromAlias(al).get();
        ItemDataNode node = this.itemDataService.getDataForItem(id);
        node.removeAlias(al);
        this.itemDataService.setDataForItem(id, node);
        src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.nucleus.removeitemalias.removed", al, id));
        return CommandResult.success();
    }
}

