/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.logging;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.logging.LogFile;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.function.Function;

public class DateRotatableFileLogger
implements Closeable {
    private static final Path nucleusBase = Paths.get("logs/nucleus", new String[0]);
    private final Path directory;
    private final String filenamePrefix;
    private Instant currentDate;
    private LogFile file;
    private final Function<String, String> formatter;
    private boolean isClosed = false;

    public DateRotatableFileLogger(String directory, String filenamePrefix, Function<String, String> formatter) throws IOException {
        Preconditions.checkNotNull((Object)directory);
        Preconditions.checkNotNull((Object)filenamePrefix);
        this.directory = nucleusBase.resolve(directory);
        this.filenamePrefix = filenamePrefix;
        this.formatter = formatter == null ? s -> s : formatter;
        Files.createDirectories(this.directory, new FileAttribute[0]);
    }

    private void openFile() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException();
        }
        if (this.file != null && !this.file.isClosed()) {
            try {
                this.file.close();
            }
            finally {
                this.file = null;
            }
        }
        int count = 0;
        boolean go = false;
        do {
            String fileName;
            Path nextFile;
            if (Files.exists(nextFile = Paths.get(fileName = this.directory.toString() + "/" + this.filenamePrefix + "-" + DateTimeFormatter.ofPattern("yyyy-MM-dd").format(Instant.now().atZone(ZoneId.systemDefault())) + "-" + ++count + ".log", new String[0]), new LinkOption[0])) {
                try {
                    Util.compressAndDeleteFile(nextFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (Files.exists(Paths.get(fileName + ".gz", new String[0]), new LinkOption[0])) continue;
            this.file = new LogFile(nextFile, this.formatter);
            go = true;
        } while (!go);
        this.currentDate = Instant.now().truncatedTo(ChronoUnit.DAYS);
    }

    public void logEntry(String entry) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException();
        }
        this.logEntry(Lists.newArrayList((Object[])new String[]{entry}), true);
    }

    public void logEntry(Iterable<String> entry) throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException();
        }
        this.logEntry(entry, true);
    }

    private void logEntry(Iterable<String> entry, boolean retryOnError) throws IOException {
        if (this.file == null || this.file.isClosed() || Instant.now().truncatedTo(ChronoUnit.DAYS).isAfter(this.currentDate)) {
            this.openFile();
        }
        try {
            Iterator<String> iterator = entry.iterator();
            while (iterator.hasNext()) {
                this.file.writeLine(iterator.next());
                iterator.remove();
            }
            this.file.flush();
        }
        catch (IOException e) {
            if (retryOnError) {
                this.logEntry(entry, false);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.file != null && !this.file.isClosed()) {
            this.file.close();
            this.file = null;
            this.isClosed = true;
        }
    }
}

