/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public final class InternalServiceManager {
    private final Map<Class<?>, Object> serviceMap = Maps.newConcurrentMap();

    public <I, C extends I> void registerService(Class<I> key, C service) {
        this.registerService(key, service, false);
    }

    public <I, C extends I> void registerService(Class<I> key, C service, boolean rereg) {
        if (!rereg && this.serviceMap.containsKey(key)) {
            return;
        }
        this.serviceMap.put(key, service);
    }

    public <I> Optional<I> getService(Class<I> key) {
        if (this.serviceMap.containsKey(key)) {
            return Optional.of(this.serviceMap.get(key));
        }
        return Optional.empty();
    }

    public <I> I getServiceUnchecked(Class<I> key) {
        if (this.serviceMap.containsKey(key)) {
            return (I)this.serviceMap.get(key);
        }
        throw new NoSuchElementException(key.getName());
    }
}

