/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.dataservices.modular;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.dataservices.modular.DataKey;
import io.github.nucleuspowered.nucleus.dataservices.modular.ModularDataService;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public abstract class DataModule<S extends ModularDataService<S>> {
    private static final Map<Class<? extends DataModule<?>>, List<FieldData>> fieldData = Maps.newHashMap();
    private static final Object lock = new Object();
    private final List<FieldData> data;
    private final Object lockingObject = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataModule() {
        Object object = lock;
        synchronized (object) {
            this.data = fieldData.computeIfAbsent(this.getClass(), this::init);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lockingObject")
    protected void loadFrom(ConfigurationNode node) {
        Object object = this.lockingObject;
        synchronized (object) {
            for (FieldData d : this.data) {
                try {
                    Optional value = this.getValue(d.clazz, d.path, node);
                    if (!value.isPresent()) continue;
                    d.field.set(this, value.get());
                }
                catch (IllegalArgumentException e) {
                    Nucleus.getNucleus().getLogger().warn("Could not set field data for " + d.field.getName() + " (data key " + d.path + ") - falling back to default.");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.migrate();
        }
    }

    protected void migrate() {
    }

    protected <T> Optional<T> getValue(TypeToken<T> token, String path, ConfigurationNode node) {
        try {
            return Optional.ofNullable(node.getNode(new Object[]{path}).getValue(token));
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lockingObject")
    protected void saveTo(ConfigurationNode node) {
        Object object = this.lockingObject;
        synchronized (object) {
            for (FieldData d : this.data) {
                try {
                    this.saveFieldData(d.clazz, d.field, d.path, node);
                }
                catch (Exception e) {
                    Nucleus.getNucleus().getLogger().error("Could not save module " + d.clazz.getType().getTypeName(), (Throwable)e);
                }
            }
        }
    }

    private <T> void saveFieldData(TypeToken<T> typeToken, Field field, String path, ConfigurationNode node) throws ObjectMappingException {
        Object t;
        try {
            t = field.get(this);
        }
        catch (IllegalAccessException e) {
            Nucleus.getNucleus().getLogger().error("Could not get data from " + this.getClass().getSimpleName() + ": " + field.getName(), (Throwable)e);
            t = null;
        }
        this.saveNode(typeToken, t, path, node);
    }

    protected <T> void saveNode(TypeToken<T> typeToken, T value, String path, ConfigurationNode node) throws ObjectMappingException {
        ConfigurationNode cn = node.getNode(new Object[]{path});
        if (value == null) {
            cn.setValue(null);
        } else {
            cn.setValue(typeToken, value);
        }
    }

    private List<FieldData> init(Class<? extends DataModule<?>> clazz) {
        List<Field> fields = Arrays.stream(clazz.getDeclaredFields()).filter(x -> x.isAnnotationPresent(DataKey.class)).collect(Collectors.toList());
        fields.forEach(x -> x.setAccessible(true));
        return fields.stream().map(x -> new FieldData(x.getAnnotation(DataKey.class).value(), TypeToken.of((Type)x.getGenericType()), (Field)x)).collect(Collectors.toList());
    }

    private static class FieldData {
        private final String path;
        private final TypeToken<?> clazz;
        private final Field field;

        private FieldData(String path, TypeToken<?> clazz, Field field) {
            this.path = path;
            this.clazz = clazz;
            this.field = field;
        }
    }

    public static abstract class ReferenceService<T extends ModularDataService<T>>
    extends DataModule<T> {
        private final WeakReference<T> modularDataService;

        @Nonnull
        protected T getService() {
            return (T)((ModularDataService)Preconditions.checkNotNull(this.modularDataService.get()));
        }

        public ReferenceService(T modularDataService) {
            this.modularDataService = new WeakReference<T>(modularDataService);
        }
    }
}

