/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.lang.ref.WeakReference;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MBlockState {
    private static BlockStateFunction toBlockState = new BlockStateFunction();
    private static BlockPredicate blockFilter = new BlockPredicate();
    protected BlockPos pos;
    protected Block block;
    protected IBlockState state;

    public MBlockState(BlockPos pos, IBlockState state) {
        this.pos = pos;
        this.block = state.func_177230_c();
        this.state = state;
    }

    public MBlockState(BlockPos pos, Block block) {
        this.pos = pos;
        this.block = block;
        this.state = block.func_176223_P();
    }

    public MBlockState(IBlockState state) {
        this.block = state.func_177230_c();
        this.state = state;
    }

    public MBlockState(Block block) {
        this.block = block;
        this.state = block.func_176223_P();
    }

    public MBlockState(IBlockAccess world, BlockPos pos) {
        this.pos = pos;
        this.state = world.func_180495_p(pos);
        this.block = this.state.func_177230_c();
        this.state = this.state.func_185899_b(world, pos);
    }

    public MBlockState(IBlockAccess world, long coord) {
        this(world, BlockPos.func_177969_a((long)coord));
    }

    public MBlockState(BlockPos pos, MBlockState state) {
        this(pos, state.getBlockState());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Block getBlock() {
        return this.block;
    }

    public IBlockState getBlockState() {
        return this.state;
    }

    public int getX() {
        return this.pos.func_177958_n();
    }

    public int getY() {
        return this.pos.func_177956_o();
    }

    public int getZ() {
        return this.pos.func_177952_p();
    }

    public boolean isAir() {
        return this.getBlockState().func_185904_a() == Material.field_151579_a;
    }

    public MBlockState offset(BlockPos pos) {
        return new MBlockState(this.pos.func_177971_a((Vec3i)pos), this);
    }

    public MBlockState rotate(int count) {
        IBlockState newState = this.state;
        for (IProperty prop : this.state.func_177228_b().keySet()) {
            if (!(prop instanceof PropertyDirection)) continue;
            EnumFacing facing = EnumFacingUtils.rotateFacing((EnumFacing)this.state.func_177229_b(prop), 4 - count);
            newState = newState.func_177226_a((IProperty)((PropertyDirection)prop), (Comparable)facing);
        }
        return new MBlockState(BlockPosUtils.rotate(this.pos, count), newState);
    }

    public void placeBlock(World world) {
        world.func_175656_a(this.pos, this.state);
    }

    public void placeBlock(World world, int flag) {
        world.func_180501_a(this.pos, this.state, flag);
    }

    public void breakBlock(World world, int flag) {
        world.func_180501_a(this.pos, Blocks.field_150350_a.func_176223_P(), flag);
    }

    public boolean matchesWorld(IBlockAccess world) {
        MBlockState mstate = new MBlockState(world, this.pos);
        return mstate.getBlock() == this.getBlock() && this.getBlock().func_176201_c(mstate.getBlockState()) == this.getBlock().func_176201_c(this.getBlockState());
    }

    public static Iterable<MBlockState> getAllInBox(IBlockAccess world, BlockPos from, BlockPos to, Block block, boolean skipAir) {
        FluentIterable it = FluentIterable.from((Iterable)BlockPos.func_177980_a((BlockPos)from, (BlockPos)to)).transform((Function)toBlockState.set(world));
        if (block != null || skipAir) {
            it.filter((Predicate)blockFilter.set(block, skipAir));
        }
        return it;
    }

    public static IBlockState fromNBT(NBTTagCompound nbt) {
        return MBlockState.fromNBT(nbt, "block", "metadata");
    }

    public static IBlockState fromNBT(NBTTagCompound nbt, String blockName, String metadataName) {
        if (nbt == null) {
            return null;
        }
        Block block = null;
        if (nbt.func_150297_b(blockName, 3)) {
            block = Block.func_149729_e((int)nbt.func_74762_e(blockName));
        } else if (nbt.func_74764_b(blockName)) {
            block = Block.func_149684_b((String)nbt.func_74779_i(blockName));
        }
        if (block == null) {
            return null;
        }
        int metadata = nbt.func_74762_e(metadataName);
        return block.func_176203_a(metadata);
    }

    public static NBTTagCompound toNBT(NBTTagCompound nbt, IBlockState state) {
        return MBlockState.toNBT(nbt, state, "block", "metadata");
    }

    public static NBTTagCompound toNBT(NBTTagCompound nbt, IBlockState state, String blockName, String metadataName) {
        if (state == null) {
            return nbt;
        }
        nbt.func_74778_a(blockName, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c())).toString());
        nbt.func_74768_a(metadataName, state.func_177230_c().func_176201_c(state));
        return nbt;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MBlockState)) {
            return false;
        }
        MBlockState bs = (MBlockState)obj;
        return this.pos.equals((Object)bs.pos) && this.block == bs.block && this.state == bs.state;
    }

    public String toString() {
        return "[" + this.pos + "] " + this.state;
    }

    public static class BlockPredicate
    implements Predicate<MBlockState> {
        public Block block;
        public boolean skipAir;

        public BlockPredicate set(Block block, boolean skipAir) {
            this.block = block;
            this.skipAir = skipAir;
            return this;
        }

        public boolean apply(MBlockState state) {
            if (this.block == null) {
                return state.getBlock() != Blocks.field_150350_a;
            }
            return state.getBlock() == this.block;
        }
    }

    public static class BlockStateFunction
    implements Function<BlockPos, MBlockState> {
        public WeakReference<IBlockAccess> world;

        public BlockStateFunction set(IBlockAccess world) {
            this.world = new WeakReference<IBlockAccess>(world);
            return this;
        }

        public MBlockState apply(BlockPos pos) {
            return new MBlockState((IBlockAccess)this.world.get(), pos);
        }
    }
}

