/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.util.Timer;
import net.malisis.core.util.Utils;

public class AnimationRenderer {
    private Timer timer = new Timer();
    private boolean clearFinished = false;
    private LinkedList<Animation<?>> animations = new LinkedList();
    private List<ITransformable> tranformables = new ArrayList<ITransformable>();
    private List<Animation<?>> toClear = new ArrayList();

    public AnimationRenderer() {
        this.timer.start();
    }

    public void setStartTime(long start) {
        this.timer.setStart(start);
    }

    public void setStartTime() {
        this.timer.start();
    }

    public void setStartTick(long start) {
        this.setStartTime(System.currentTimeMillis() - (this.getWorldTime() - start) * 1000L / 20L);
    }

    public long getWorldTime() {
        if (Utils.getClientWorld() != null) {
            return Utils.getClientWorld().func_82737_E();
        }
        return 0L;
    }

    public long getElapsedTime() {
        return this.timer.elapsedTime();
    }

    public float getElapsedTicks() {
        return this.timer.elapsedTick();
    }

    public void addAnimation(Animation<?> animation) {
        this.animations.add(animation);
    }

    public void deleteAnimation(Animation<?> animation) {
        this.animations.remove(animation);
    }

    public void clearAnimations() {
        this.animations.clear();
    }

    public void autoClearAnimations() {
        this.clearFinished = true;
    }

    public List<ITransformable> animate(Animation<?> ... animations) {
        return this.animate(this.timer, animations);
    }

    public List<ITransformable> animate(Timer timer, Animation<?> ... animations) {
        this.tranformables.clear();
        this.toClear.clear();
        if (animations == null || animations.length == 0) {
            return this.tranformables;
        }
        Object tr = null;
        for (Animation<?> animation : animations) {
            tr = animation.animate(timer);
            if (tr != null) {
                this.tranformables.add((ITransformable)tr);
            }
            if (!animation.isFinished() || !this.clearFinished) continue;
            this.toClear.add(animation);
        }
        return this.tranformables;
    }

    public List<ITransformable> animate() {
        List<ITransformable> anims = this.animate(this.animations.toArray(new Animation[0]));
        for (Animation<?> animation : this.toClear) {
            this.animations.remove(animation);
        }
        return anims;
    }

    public <S extends ITransformable> void animate(S transformable, Transformation<?, S> animation) {
        if (transformable == null) {
            return;
        }
        animation.transform(transformable, this.getElapsedTime());
    }
}

