/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.utils;

import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class MessageUtils {
    public static void sendMessage(Player player, String message) {
        MessageUtils.sendMessage(player, message, TextColors.WHITE);
    }

    public static void sendErrorMessage(Player player, String message) {
        MessageUtils.sendMessage(player, message, TextColors.RED);
    }

    public static void sendErrorMessage(CommandSource source, String message) {
        MessageUtils.sendMessage(source, message, TextColors.RED);
    }

    public static void sendSuccessMessage(Player player, String message) {
        MessageUtils.sendMessage(player, message, TextColors.GREEN);
    }

    public static void sendSuccessMessage(CommandSource source, String message) {
        MessageUtils.sendMessage(source, message, TextColors.GREEN);
    }

    public static void sendMessage(Player player, String message, TextColor color) {
        player.sendMessage(Text.of((Object[])new Object[]{color, message}));
    }

    public static void sendMessage(CommandSource source, String message, TextColor color) {
        source.sendMessage(Text.of((Object[])new Object[]{color, message}));
    }

    public static void sendHotbarMessage(Player player, String message) {
        MessageUtils.sendHotbarMessage(player, message, TextColors.GOLD);
    }

    public static void sendHotbarErrorMessage(Player player, String message) {
        MessageUtils.sendHotbarMessage(player, message, TextColors.RED);
    }

    public static void sendHotbarSuccessMessage(Player player, String message) {
        MessageUtils.sendHotbarMessage(player, message, TextColors.GREEN);
    }

    public static void sendHotbarMessage(Player player, String message, TextColor color) {
        player.sendMessage(ChatTypes.ACTION_BAR, Text.of((Object[])new Object[]{color, message}));
    }
}

