/*
 * Decompiled with CFR 0.152.
 */
package com.universeguard.event.flags;

import com.universeguard.region.LocalRegion;
import com.universeguard.region.Region;
import com.universeguard.region.enums.EnumRegionFlag;
import com.universeguard.utils.MessageUtils;
import com.universeguard.utils.RegionUtils;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class FlagFarewellListener {
    @Listener
    public void onFarewell(MoveEntityEvent event) {
        if (event.getTargetEntity() instanceof Player) {
            this.handleEvent(event, (Player)event.getTargetEntity());
        } else if (!event.getTargetEntity().getPassengers().isEmpty()) {
            for (Entity entity : event.getTargetEntity().getPassengers()) {
                if (!(entity instanceof Player)) continue;
                this.handleEvent(event, (Player)entity);
            }
        }
    }

    public void handleEvent(MoveEntityEvent event, Player player) {
        Location from = event.getFromTransform().getLocation();
        Region regionFrom = RegionUtils.getRegion((Location<World>)from);
        if (regionFrom.isLocal()) {
            Location to = event.getToTransform().getLocation();
            Region regionTo = RegionUtils.getRegion((Location<World>)to);
            if (regionFrom != null && regionTo != null && regionFrom != regionTo && regionFrom.getFlag(EnumRegionFlag.EXIT) && !((LocalRegion)regionFrom).getFarewellMessage().isEmpty()) {
                MessageUtils.sendHotbarErrorMessage(player, ((LocalRegion)regionFrom).getFarewellMessage());
            }
        }
    }
}

