/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop.shop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.ShopConfig;
import com.carrot.carrotshop.ShopsData;
import com.carrot.carrotshop.shop.Shop;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.economy.account.Account;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.economy.transaction.ResultType;
import org.spongepowered.api.service.economy.transaction.TransactionResult;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@ConfigSerializable
public class DeviceOff
extends Shop {
    @Setting
    private Location<World> lever;
    @Setting
    private float price;
    private static String type = "DeviceOff";

    public DeviceOff() {
    }

    public DeviceOff(Player player, Location<World> sign) throws ExceptionInInitializerError {
        super(sign);
        if (!player.hasPermission("carrotshop.create.device")) {
            throw new ExceptionInInitializerError(Lang.SHOP_PERM.replace("%type%", type));
        }
        Stack<Location<World>> locations = ShopsData.getItemLocations(player);
        if (locations.isEmpty()) {
            throw new ExceptionInInitializerError(Lang.SHOP_LEVER.replace("%type%", type));
        }
        BlockState targetBlock = locations.peek().getBlock();
        if (!targetBlock.getType().equals(BlockTypes.LEVER)) {
            throw new ExceptionInInitializerError(Lang.SHOP_LEVER.replace("%type%", type));
        }
        this.lever = locations.peek();
        float cost = 0.0f;
        if (CarrotShop.getEcoService() != null) {
            UniqueAccount buyerAccount;
            TransactionResult result;
            this.price = DeviceOff.getPrice(sign);
            if (this.price < 0.0f) {
                throw new ExceptionInInitializerError(Lang.SHOP_PRICE);
            }
            String[] stringArray = new String[]{"cost", type};
            cost = ShopConfig.getNode(stringArray).getFloat(0.0f);
            if (cost > 0.0f && (result = (buyerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get()).withdraw(this.getCurrency(), BigDecimal.valueOf(cost), CarrotShop.getCause())).getResult() != ResultType.SUCCESS) {
                throw new ExceptionInInitializerError(Lang.SHOP_COST.replace("%type%", type).replace("%cost%", this.formatPrice(BigDecimal.valueOf(cost))));
            }
        }
        this.setOwner(player);
        ShopsData.clearItemLocations(player);
        if (cost > 0.0f) {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE_COST.replace("%type%", type).replace("%cost%", this.formatPrice(BigDecimal.valueOf(cost)))}));
        } else {
            player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, Lang.SHOP_DONE.replace("%type%", type)}));
        }
        this.done(player);
        this.info(player);
    }

    @Override
    public List<Location<World>> getLocations() {
        List<Location<World>> locations = super.getLocations();
        locations.add(this.lever);
        return locations;
    }

    @Override
    public void info(Player player) {
        if (CarrotShop.getEcoService() != null) {
            player.sendMessage((Text)Text.of((String)Lang.SHOP_DEVICEOFF_HELP.replace("%price%", this.formatPrice(this.price))));
        } else {
            player.sendMessage((Text)Text.of((String)Lang.SHOP_DEVICEOFF_HELP_NOECON));
        }
        this.update();
    }

    @Override
    public boolean trigger(Player player) {
        Optional seller;
        String recap = Lang.SHOP_DEVICEOFF_NOECON;
        String orecap = Lang.SHOP_DEVICE_OTHER_NOECON;
        if (CarrotShop.getEcoService() != null) {
            TransactionResult accountResult;
            UniqueAccount buyerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(player.getUniqueId()).get();
            UniqueAccount sellerAccount = (UniqueAccount)CarrotShop.getEcoService().getOrCreateAccount(this.getOwner()).get();
            String[] stringArray = new String[]{"taxes", type};
            float tax = ShopConfig.getNode(stringArray).getFloat(0.0f);
            if (tax > 0.0f) {
                accountResult = buyerAccount.withdraw(this.getCurrency(), BigDecimal.valueOf(this.price), CarrotShop.getCause());
                if (accountResult.getResult() == ResultType.SUCCESS) {
                    accountResult = sellerAccount.deposit(this.getCurrency(), BigDecimal.valueOf(this.price - this.price * tax / 100.0f), CarrotShop.getCause());
                }
            } else {
                accountResult = buyerAccount.transfer((Account)sellerAccount, this.getCurrency(), BigDecimal.valueOf(this.price), CarrotShop.getCause());
            }
            if (accountResult.getResult() != ResultType.SUCCESS) {
                player.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_RED, Lang.SHOP_MONEY}));
                return false;
            }
            recap = Lang.SHOP_DEVICEOFF.replace("%price%", this.formatPrice(this.price));
            orecap = tax > 0.0f ? Lang.SHOP_DEVICE_OTHER_TAX.replace("%tax%", String.valueOf(tax)).replace("%tprice%", this.formatPrice(this.price - this.price * tax / 100.0f)) : Lang.SHOP_DEVICE_OTHER;
            orecap = orecap.replace("%price%", this.formatPrice(this.price));
        }
        this.lever.offer(Keys.POWERED, (Object)false);
        player.sendMessage((Text)Text.of((String)recap));
        if (!CarrotShop.noSpam(this.getOwner()) && (seller = Sponge.getServer().getPlayer(this.getOwner())).isPresent()) {
            ((Player)seller.get()).sendMessage((Text)Text.of((String)orecap.replace("%player%", player.getName()).replace("%type%", type)));
        }
        return true;
    }
}

