/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.generator;

import gcewing.sg.generator.FeatureGeneration;
import gcewing.sg.generator.FeatureIgloo;
import gcewing.sg.generator.FeatureJungleTemple;
import gcewing.sg.generator.FeatureNetherFortress;
import gcewing.sg.generator.FeatureOceanMonument;
import gcewing.sg.generator.FeatureStargate;
import gcewing.sg.generator.FeatureSwampHut;
import gcewing.sg.generator.FeatureUnderDesertPyramid;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraft.world.gen.structure.StructureOceanMonumentPieces;
import net.minecraft.world.gen.structure.StructureStart;

class SGStructureMap
extends Long2ObjectOpenHashMap {
    public SGStructureMap() {
        super(1024);
    }

    public Object put(long key, Object value) {
        if (value instanceof StructureStart) {
            this.augmentStructureStart((StructureStart)value);
        }
        return super.put(key, value);
    }

    void augmentStructureStart(StructureStart start) {
        List oldComponents = start.func_186161_c();
        ArrayList<FeatureUnderDesertPyramid> newComponents = new ArrayList<FeatureUnderDesertPyramid>();
        FeatureStargate newComp = null;
        for (Object comp : oldComponents) {
            newComp = null;
            if (comp instanceof ComponentScatteredFeaturePieces.DesertPyramid && FeatureGeneration.pyramidAddon) {
                newComp = new FeatureUnderDesertPyramid((StructureComponent)comp);
            } else if (comp instanceof ComponentScatteredFeaturePieces.SwampHut && FeatureGeneration.swampAddon) {
                newComp = new FeatureSwampHut((StructureComponent)comp);
            } else if (comp instanceof ComponentScatteredFeaturePieces.Igloo && FeatureGeneration.iglooAddon) {
                newComp = new FeatureIgloo((StructureComponent)comp);
            } else if (comp instanceof ComponentScatteredFeaturePieces.JunglePyramid && FeatureGeneration.jungleAddon) {
                newComp = new FeatureJungleTemple((StructureComponent)comp);
            } else if (comp instanceof StructureNetherBridgePieces.Start) {
                newComp = new FeatureNetherFortress((StructureComponent)comp);
            } else if (comp instanceof StructureOceanMonumentPieces.MonumentBuilding) {
                newComp = new FeatureOceanMonument((StructureComponent)comp);
            }
            if (newComp == null) continue;
            StructureBoundingBox box = ((StructureComponent)comp).func_74874_b();
            start.func_75071_a().func_78888_b(newComp.func_74874_b());
            newComponents.add((FeatureUnderDesertPyramid)newComp);
        }
        oldComponents.addAll(newComponents);
    }
}

