/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories.handling;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sonar.core.api.StorageSize;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.handlers.inventories.handling.SimpleChangeableHandler;

public class ItemTransferHelper {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;

    @Nullable
    public static IItemHandler getItemHandlerOffset(World world, BlockPos pos, EnumFacing face) {
        return ItemTransferHelper.getItemHandler(world, pos.func_177972_a(face), face.func_176734_d());
    }

    @Nullable
    public static IItemHandler getItemHandler(World world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        return ItemTransferHelper.getItemHandler((ICapabilityProvider)tile, face);
    }

    @Nullable
    public static IItemHandler getItemHandler(ICapabilityProvider provider, EnumFacing face) {
        if (provider != null && provider.hasCapability(ITEM_HANDLER_CAPABILITY, face)) {
            return (IItemHandler)provider.getCapability(ITEM_HANDLER_CAPABILITY, face);
        }
        return null;
    }

    @Nonnull
    public static IItemHandler getMainInventoryHandler(EntityPlayer player) {
        return ItemTransferHelper.getItemHandler((ICapabilityProvider)player, EnumFacing.UP);
    }

    @Nonnull
    public static IItemHandler getEquipmentInventoryHandler(EntityPlayer player) {
        return ItemTransferHelper.getItemHandler((ICapabilityProvider)player, EnumFacing.NORTH);
    }

    @Nonnull
    public static IItemHandler getJoinedInventoryHandler(EntityPlayer player) {
        return ItemTransferHelper.getItemHandler((ICapabilityProvider)player, null);
    }

    public static boolean isInvalidItemHandler(IItemHandler handler) {
        return handler == null || handler instanceof SimpleChangeableHandler && !((SimpleChangeableHandler)handler).isValid();
    }

    public static void doSimpleTransfer(Iterable<IItemHandler> sources, Iterable<IItemHandler> destinations, Predicate<ItemStack> filter, int maximum) {
        int usage = maximum == -1 ? Integer.MAX_VALUE : maximum;
        for (IItemHandler source : sources) {
            if (ItemTransferHelper.isInvalidItemHandler(source)) continue;
            for (int i = 0; i < source.getSlots(); ++i) {
                ItemStack extract = source.extractItem(i, Math.min(usage, source.getSlotLimit(i)), true);
                if (extract.func_190926_b() || !filter.test(extract)) continue;
                int count_before = extract.func_190916_E();
                extract = ItemTransferHelper.doInsert(extract, destinations);
                int count_change = count_before - extract.func_190916_E();
                source.extractItem(i, Math.min(count_change, source.getSlotLimit(i)), false);
                if ((usage -= count_change) > 0) continue;
                return;
            }
        }
    }

    public static void doSimpleTransfer(Iterable<IItemHandler> sources, Iterable<IItemHandler> destinations, Predicate<ItemStack> filter) {
        for (IItemHandler source : sources) {
            if (ItemTransferHelper.isInvalidItemHandler(source)) continue;
            for (int i = 0; i < source.getSlots(); ++i) {
                ItemStack extract = source.extractItem(i, source.getSlotLimit(i), true);
                if (extract.func_190926_b() || !filter.test(extract)) continue;
                int count_before = extract.func_190916_E();
                extract = ItemTransferHelper.doInsert(extract, destinations);
                int count_change = count_before - extract.func_190916_E();
                source.extractItem(i, Math.min(count_change, source.getSlotLimit(i)), false);
            }
        }
    }

    public static void doTransferFromSlot(IItemHandler source, Iterable<IItemHandler> destinations, int sourceSlot) {
        if (ItemTransferHelper.isInvalidItemHandler(source)) {
            return;
        }
        ItemStack extract = source.extractItem(sourceSlot, source.getSlotLimit(sourceSlot), true);
        if (!extract.func_190926_b()) {
            int count_before = extract.func_190916_E();
            extract = ItemTransferHelper.doInsert(extract, destinations);
            int count_change = count_before - extract.func_190916_E();
            source.extractItem(sourceSlot, Math.min(count_change, source.getSlotLimit(sourceSlot)), false);
        }
    }

    public static ItemStack doInsert(ItemStack insert, Iterable<IItemHandler> destinations) {
        for (IItemHandler destination : destinations) {
            if (ItemTransferHelper.isInvalidItemHandler(destination) || !(insert = ItemHandlerHelper.insertItemStacked((IItemHandler)destination, (ItemStack)insert, (boolean)false)).func_190926_b()) continue;
            return insert;
        }
        return insert;
    }

    public static ItemStack doExtract(Iterable<IItemHandler> sources, Predicate<ItemStack> filter, int maximum) {
        ItemStack extracted = ItemStack.field_190927_a;
        block0: for (IItemHandler source : sources) {
            if (ItemTransferHelper.isInvalidItemHandler(source)) continue;
            for (int i = 0; i < source.getSlots(); ++i) {
                ItemStack extract = source.extractItem(i, Math.min(source.getSlotLimit(i), maximum - extracted.func_190916_E()), true);
                if (extract.func_190926_b() || !filter.test(extract)) continue;
                extract = source.extractItem(i, extract.func_190916_E(), false);
                if (extracted.func_190926_b()) {
                    extracted = extract;
                } else {
                    extracted.func_190917_f(extract.func_190916_E());
                }
                if (extracted.func_190916_E() >= maximum) break block0;
            }
        }
        return extracted;
    }

    @Deprecated
    public static StorageSize addInventoryToList(List<StoredItemStack> list, IInventory inv) {
        long stored = 0L;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            stored += (long)stack.func_190916_E();
            ItemTransferHelper.addStackToList(list, inv.func_70301_a(i));
        }
        int max = inv.func_70297_j_() * inv.func_70302_i_();
        return new StorageSize(stored, max);
    }

    @Deprecated
    public static StorageSize addItemHandlerToList(List<StoredItemStack> list, IItemHandler inv) {
        long stored = 0L;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            stored += (long)stack.func_190916_E();
            ItemTransferHelper.addStackToList(list, stack);
        }
        return new StorageSize(stored, inv.getSlots() * 64);
    }

    @Deprecated
    public static void addStackToList(List<StoredItemStack> list, ItemStack stack) {
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(new StoredItemStack(stack));
    }

    @Deprecated
    public static void addStackToList(List<StoredItemStack> list, StoredItemStack stack) {
        if (stack == null || list == null) {
            return;
        }
        int pos = 0;
        for (StoredItemStack storedStack : list) {
            if (storedStack.equalStack(stack.item)) {
                list.get(pos).add(stack);
                return;
            }
            ++pos;
        }
        list.add(stack);
    }
}

