/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.item;

import java.util.EnumSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import tonius.simplyjetpacks.client.model.PackModelType;
import tonius.simplyjetpacks.config.ConfigWrapper;
import tonius.simplyjetpacks.config.PackDefaults;
import tonius.simplyjetpacks.item.MetaItemsMods;
import tonius.simplyjetpacks.setup.ModItems;

public enum Fluxpack implements IStringSerializable
{
    FLUXPACK_CREATIVE("fluxpack_creative", "fluxpack_creative", 6, EnumRarity.EPIC, false, true),
    FLUXPACK_EIO1("fluxpack_eio1", "fluxpack_eio1", 1, EnumRarity.COMMON),
    FLUXPACK_EIO2("fluxpack_eio2", "fluxpack_eio2", 2, EnumRarity.UNCOMMON),
    FLUXPACK_EIO3("fluxpack_eio3", "fluxpack_eio3", 3, EnumRarity.RARE),
    FLUXPACK_EIO1_ARMORED("fluxpack_eio1_armored", "fluxpack_eio1", 1, EnumRarity.COMMON, true, true, MetaItemsMods.ARMOR_PLATING_EIO_1.ordinal()),
    FLUXPACK_EIO2_ARMORED("fluxpack_eio2_armored", "fluxpack_eio2", 2, EnumRarity.UNCOMMON, true, true, MetaItemsMods.ARMOR_PLATING_EIO_2.ordinal()),
    FLUXPACK_EIO3_ARMORED("fluxpack_eio3_armored", "fluxpack_eio3", 3, EnumRarity.RARE, true, true, MetaItemsMods.ARMOR_PLATING_EIO_3.ordinal()),
    FLUXPACK_TE1("fluxpack_te1", "fluxpack_te1", 1, EnumRarity.COMMON),
    FLUXPACK_TE2("fluxpack_te2", "fluxpack_te2", 2, EnumRarity.COMMON),
    FLUXPACK_TE3("fluxpack_te3", "fluxpack_te3", 3, EnumRarity.UNCOMMON),
    FLUXPACK_TE4("fluxpack_te4", "fluxpack_te4", 4, EnumRarity.RARE),
    FLUXPACK_TE1_ARMORED("fluxpack_te1_armored", "fluxpack_te1", 1, EnumRarity.COMMON, true, true, MetaItemsMods.ARMOR_PLATING_TE_1.ordinal()),
    FLUXPACK_TE2_ARMORED("fluxpack_te2_armored", "fluxpack_te2", 2, EnumRarity.COMMON, true, true, MetaItemsMods.ARMOR_PLATING_TE_2.ordinal()),
    FLUXPACK_TE3_ARMORED("fluxpack_te3_armored", "fluxpack_te3", 3, EnumRarity.UNCOMMON, true, true, MetaItemsMods.ARMOR_PLATING_TE_3.ordinal()),
    FLUXPACK_TE4_ARMORED("fluxpack_te4_armored", "fluxpack_te4", 4, EnumRarity.RARE, true, true, MetaItemsMods.ARMOR_PLATING_TE_4.ordinal());

    protected final PackDefaults defaults;
    protected static final EnumSet<Fluxpack> FLUXPACKS_ALL;
    protected static final EnumSet<Fluxpack> FLUXPACKS_SJ;
    public static final EnumSet<Fluxpack> FLUXPACKS_EIO;
    public static final EnumSet<Fluxpack> FLUXPACKS_EIO_ARMORED;
    public static final EnumSet<Fluxpack> FLUXPACKS_TE;
    public static final EnumSet<Fluxpack> FLUXPACKS_TE_ARMORED;
    @Nonnull
    public final String baseName;
    @Nonnull
    public final String unlocalisedName;
    public final int tier;
    public int energyCapacity;
    public int energyPerTickIn;
    public int energyPerTickOut;
    public int armorEnergyPerHit;
    public int armorReduction;
    public int energyUsage;
    public int platingMeta;
    public boolean usesEnergy;
    public boolean isArmored;
    public EnumRarity rarity;
    public PackModelType armorModel = PackModelType.FLAT;
    public int enchantability;

    private Fluxpack(String baseName, String configKey, int tier, EnumRarity rarity, boolean usesEnergy) {
        this(baseName, configKey, tier, rarity);
        this.usesEnergy = usesEnergy;
    }

    private Fluxpack(String baseName, String configKey, int tier, EnumRarity rarity, boolean usesEnergy, boolean isArmored) {
        this(baseName, configKey, tier, rarity, usesEnergy);
        this.isArmored = isArmored;
    }

    private Fluxpack(String baseName, String configKey, int tier, EnumRarity rarity, boolean usesEnergy, boolean isArmored, int platingMeta) {
        this(baseName, configKey, tier, rarity, usesEnergy);
        this.isArmored = isArmored;
        this.platingMeta = platingMeta;
    }

    private Fluxpack(String baseName, String configKey, int tier, EnumRarity rarity) {
        this.baseName = baseName;
        this.defaults = PackDefaults.get(configKey);
        this.tier = tier;
        this.unlocalisedName = "item.simplyjetpacks." + baseName;
        this.usesEnergy = true;
        this.rarity = rarity;
        this.setArmorModel(PackModelType.FLUXPACK);
    }

    @Nonnull
    public String getBaseName() {
        return this.baseName;
    }

    public int getEnergyCapacity() {
        return this.energyCapacity;
    }

    public int getTier() {
        return this.tier;
    }

    public int getEnergyPerTickIn() {
        return this.energyPerTickIn;
    }

    public int getEnergyPerTickOut() {
        return this.energyPerTickOut;
    }

    public int getArmorEnergyPerHit() {
        return this.armorEnergyPerHit;
    }

    public int getArmorReduction() {
        return this.armorReduction;
    }

    public int getEnergyUsage() {
        return this.energyUsage;
    }

    public String func_176610_l() {
        return this.baseName.toLowerCase(Locale.ENGLISH);
    }

    public EnumRarity getRarity() {
        return this.rarity;
    }

    public boolean getIsArmored() {
        return this.isArmored;
    }

    public int getPlatingMeta() {
        return this.platingMeta;
    }

    @Nonnull
    public ItemStack getStackFluxpack() {
        return new ItemStack((Item)ModItems.itemFluxpack, 1, this.ordinal());
    }

    @Nonnull
    public static Fluxpack getTypeFromMeta(int meta) {
        return Fluxpack.values()[meta >= 0 && meta < Fluxpack.values().length ? meta : 0];
    }

    public static int getMetaFromType(Fluxpack value) {
        return value.ordinal();
    }

    public Fluxpack setArmorModel(PackModelType armorModel) {
        this.armorModel = armorModel;
        return this;
    }

    public boolean getGlow() {
        return this.baseName.contains("creative");
    }

    public static void loadAllConfigs(ConfigWrapper config) {
        for (Fluxpack pack : FLUXPACKS_SJ) {
            pack.loadConfig(config);
        }
        if (ModItems.integrateEIO) {
            for (Fluxpack pack : FLUXPACKS_EIO) {
                pack.loadConfig(config);
            }
        }
        if (ModItems.integrateTE) {
            for (Fluxpack pack : FLUXPACKS_TE) {
                pack.loadConfig(config);
            }
        }
    }

    protected void loadConfig(ConfigWrapper config) {
        if (this.defaults.energyCapacity != null) {
            this.energyCapacity = config.getIntS(this.defaults.section.category, "energyCapacity", "tuning", this.defaults.energyCapacity, 1, null, false);
        }
        if (this.defaults.energyUsage != null) {
            this.energyUsage = config.getIntS(this.defaults.section.category, "energyUsage", "tuning", this.defaults.energyUsage, 0, null, false);
        }
        if (this.defaults.energyPerTickIn != null) {
            this.energyPerTickIn = config.getIntS(this.defaults.section.category, "energyPerTickIn", "tuning", this.defaults.energyPerTickIn, 0, null, false);
        }
        if (this.defaults.energyPerTickOut != null) {
            this.energyPerTickOut = config.getIntS(this.defaults.section.category, "energyPerTickOut", "tuning", this.defaults.energyPerTickOut, 0, null, false);
        }
        if (this.defaults.armorReduction != null) {
            this.armorReduction = config.getIntS(this.defaults.section.category, "armorReduction", "tuning", this.defaults.armorReduction, 0, 20, false);
        }
        if (this.defaults.armorEnergyPerHit != null) {
            this.armorEnergyPerHit = config.getIntS(this.defaults.section.category, "armorEnergyPerHit", "tuning", this.defaults.armorEnergyPerHit, 0, null, false);
        }
        if (this.defaults.enchantability != null) {
            this.enchantability = config.getIntS(this.defaults.section.category, "enchantability", "tuning", this.defaults.enchantability, 0, null, false);
        }
    }

    static {
        FLUXPACKS_ALL = EnumSet.allOf(Fluxpack.class);
        FLUXPACKS_SJ = EnumSet.of(FLUXPACK_CREATIVE);
        FLUXPACKS_EIO = EnumSet.range(FLUXPACK_EIO1, FLUXPACK_EIO3_ARMORED);
        FLUXPACKS_EIO_ARMORED = EnumSet.range(FLUXPACK_EIO1_ARMORED, FLUXPACK_EIO3_ARMORED);
        FLUXPACKS_TE = EnumSet.range(FLUXPACK_TE1, FLUXPACK_TE4_ARMORED);
        FLUXPACKS_TE_ARMORED = EnumSet.range(FLUXPACK_TE1_ARMORED, FLUXPACK_TE4_ARMORED);
    }
}

