/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.albedo;

import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import java.awt.Color;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.common.block.tile.TileLightRelay;
import vazkii.botania.common.entity.EntityBabylonWeapon;
import vazkii.botania.common.entity.EntityFallingStar;
import vazkii.botania.common.entity.EntityFlameRing;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.entity.EntityPixie;

public class AlbedoCompat {
    private static ResourceLocation CAP_NAME = new ResourceLocation("botania", "albedo_light");
    @CapabilityInject(value=ILightProvider.class)
    private static final Capability<ILightProvider> LIGHT_CAPABILITY = null;

    @SubscribeEvent
    public static void attachLights(AttachCapabilitiesEvent<Entity> event) {
        Entity e = (Entity)event.getObject();
        if (e instanceof EntityFlameRing) {
            AlbedoCompat.addLight(event, entity -> Light.builder().pos(entity).color(1.0f, 0.5f, 0.0f).radius(20.0f).build());
        } else if (e instanceof EntityPixie) {
            AlbedoCompat.addLight(event, pixie -> pixie.getType() == 1 ? null : Light.builder().pos((Entity)pixie).color(1.0f, 0.0f, 0.5f).radius(8.0f).build());
        } else if (e instanceof EntityManaBurst) {
            AlbedoCompat.addLight(event, burst -> {
                int color = burst.getColor();
                return Light.builder().pos(burst.field_70165_t - burst.field_70159_w, burst.field_70163_u - burst.field_70181_x, burst.field_70161_v - burst.field_70179_y).color(color, false).radius(burst.getParticleSize() * 8.0f).build();
            });
        } else if (e instanceof TileLightRelay.EntityPlayerMover) {
            AlbedoCompat.addLight(event, mover -> {
                if (mover.func_184188_bt().isEmpty()) {
                    return null;
                }
                Entity passenger = (Entity)mover.func_184188_bt().get(0);
                Color color = Color.getHSBColor((float)passenger.field_70173_aa / 36.0f, 1.0f, 1.0f);
                return Light.builder().pos((Entity)mover).color(color.getRGB(), false).radius(5.0f).build();
            });
        } else if (e instanceof EntityFallingStar) {
            AlbedoCompat.addLight(event, entity -> Light.builder().pos(entity).color(1.0f, 0.0f, 1.0f).radius(12.0f).build());
        } else if (e instanceof EntityBabylonWeapon) {
            AlbedoCompat.addLight(event, entity -> Light.builder().pos(entity).color(1.0f, 1.0f, 0.0f).radius(8.0f).build());
        } else if (e instanceof EntityMagicLandmine) {
            AlbedoCompat.addLight(event, entity -> Light.builder().pos(entity).color(0.6f, 0.0f, 1.0f).radius(15.0f).build());
        }
    }

    private static <T extends Entity> void addLight(AttachCapabilitiesEvent<Entity> event, Function<T, Light> lightFunction) {
        event.addCapability(CAP_NAME, new BotaniaLightProvider<T>(lightFunction));
    }

    private static class BotaniaLightProvider<E extends Entity>
    implements ILightProvider,
    ICapabilityProvider {
        private Function<E, Light> lightFunction;

        BotaniaLightProvider(Function<E, Light> light) {
            this.lightFunction = light;
        }

        public void gatherLights(GatherLightsEvent event, Entity context) {
            Light light = this.lightFunction.apply(context);
            if (light != null) {
                event.add(light);
            }
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == LIGHT_CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == LIGHT_CAPABILITY ? LIGHT_CAPABILITY.cast((Object)this) : null);
        }
    }
}

