/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.smart;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_Connector;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityFeedthrough;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.lwjgl.util.vector.Vector3f;

public class FeedthroughModel
implements IBakedModel {
    public static final Cache<FeedthroughCacheKey, SpecificFeedthroughModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build();
    private ItemCameraTransforms transform = new ItemCameraTransforms(new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransformVec3f(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(), new Vector3f()), new ItemTransformVec3f(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.6f, 0.6f, 0.6f)), new ItemTransformVec3f(new Vector3f(), new Vector3f(0.0f, 0.3f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransformVec3f(new Vector3f(0.0f, 180.0f, 45.0f), new Vector3f(0.0f, 0.0f, -0.1875f), new Vector3f(0.5f, 0.5f, 0.5f)));
    private static final FeedthroughItemOverride INSTANCE = new FeedthroughItemOverride();

    public FeedthroughModel() {
        Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter = rl -> Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString());
        for (WireApi.FeedthroughModelInfo f : WireApi.INFOS.values()) {
            f.onResourceReload(bakedTextureGetter, DefaultVertexFormats.field_176599_b);
        }
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        TileEntity te;
        IBlockState baseState = Blocks.field_150348_b.func_176223_P();
        WireType wire = WireType.COPPER;
        EnumFacing facing = EnumFacing.NORTH;
        int offset = 1;
        BlockPos p = null;
        World w = null;
        if (state instanceof IExtendedBlockState && (te = (TileEntity)((IExtendedBlockState)state).getValue(IEProperties.TILEENTITY_PASSTHROUGH)) instanceof TileEntityFeedthrough) {
            baseState = ((TileEntityFeedthrough)te).stateForMiddle;
            wire = ((TileEntityFeedthrough)te).reference;
            facing = ((TileEntityFeedthrough)te).getFacing();
            offset = ((TileEntityFeedthrough)te).offset;
            p = te.func_174877_v();
            w = te.func_145831_w();
        }
        BlockPos pFinal = p;
        World wFinal = w;
        FeedthroughCacheKey key = new FeedthroughCacheKey(wire, baseState, offset, facing, MinecraftForgeClient.getRenderLayer());
        try {
            return ((SpecificFeedthroughModel)CACHE.get((Object)key, () -> new SpecificFeedthroughModel(key, wFinal, pFinal))).func_188616_a(state, side, rand);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return ImmutableList.of();
        }
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return ModelLoader.White.INSTANCE;
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.transform;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return INSTANCE;
    }

    private static class SpecificFeedthroughModel
    extends FeedthroughModel {
        private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private static final Vector3f[] vertices = new Vector3f[]{new Vector3f(0.75f, 0.001f, 0.75f), new Vector3f(0.75f, 0.001f, 0.25f), new Vector3f(0.25f, 0.001f, 0.25f), new Vector3f(0.25f, 0.001f, 0.75f)};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(6);

        public SpecificFeedthroughModel(ItemStack stack) {
            WireType w = WireType.getValue(ItemNBTHelper.getString(stack, "wire"));
            IBlockState state = Utils.stateFromNBT(ItemNBTHelper.getTagCompound(stack, "middle"));
            this.init(new FeedthroughCacheKey(w, state, Integer.MAX_VALUE, EnumFacing.NORTH, null), null, null);
        }

        public SpecificFeedthroughModel(FeedthroughCacheKey key, World w, BlockPos p) {
            this.init(key, w, p);
        }

        private void init(FeedthroughCacheKey k, @Nullable World world, @Nullable BlockPos pos) {
            ItemColors colors;
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(k.baseState);
            Function<Integer, Integer> colorMultiplier = null;
            if (world != null && pos != null) {
                colors = Minecraft.func_71410_x().func_184125_al();
                colorMultiplier = arg_0 -> SpecificFeedthroughModel.lambda$init$0((BlockColors)colors, k, world, pos, arg_0);
            } else {
                colors = Minecraft.func_71410_x().getItemColors();
                ItemStack stack = new ItemStack(k.baseState.func_177230_c(), 1, k.baseState.func_177230_c().func_176201_c(k.baseState));
                colorMultiplier = i -> colors.func_186728_a(stack, i.intValue());
            }
            for (int j = 0; j < 7; ++j) {
                EnumFacing side = j < 6 ? EnumFacing.field_82609_l[j] : null;
                EnumFacing facing = k.facing;
                switch (k.offset) {
                    case 0: {
                        if (k.layer != null && !k.baseState.func_177230_c().canRenderInLayer(k.baseState, k.layer)) break;
                        Function<BakedQuad, BakedQuad> tintTransformer = ApiUtils.transformQuad(new Matrix4(), DefaultVertexFormats.field_176599_b, colorMultiplier);
                        this.quads.add(model.func_188616_a(k.baseState, side, 0L).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new)));
                        break;
                    }
                    case 1: {
                        facing = facing.func_176734_d();
                    }
                    case -1: {
                        if (k.layer != BlockRenderLayer.SOLID) break;
                        this.quads.add(this.getConnQuads(facing, side, k.type, new Matrix4()));
                        break;
                    }
                    case 0x7FFFFFFF: {
                        Matrix4 mat = new Matrix4();
                        mat.translate(0.0, 0.0, 1.0);
                        ArrayList<BakedQuad> all = new ArrayList<BakedQuad>(this.getConnQuads(facing, side, k.type, mat));
                        mat = new Matrix4();
                        mat.translate(0.0, 0.0, -1.0);
                        all.addAll(this.getConnQuads(facing.func_176734_d(), side, k.type, mat));
                        Function<BakedQuad, BakedQuad> tintTransformer = ApiUtils.transformQuad(new Matrix4(), DefaultVertexFormats.field_176599_b, colorMultiplier);
                        all.addAll(model.func_188616_a(k.baseState, side, 0L).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new)));
                        this.quads.add(all);
                    }
                }
                if (this.quads.size() > j) continue;
                this.quads.add((List<BakedQuad>)ImmutableList.of());
            }
        }

        private List<BakedQuad> getConnQuads(EnumFacing facing, EnumFacing side, WireType type, Matrix4 mat) {
            Function<BakedQuad, BakedQuad> transf;
            WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(type);
            mat.translate(0.5, 0.5, 0.5);
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                if (facing == EnumFacing.UP) {
                    mat.rotate(Math.PI, 1.0, 0.0, 0.0);
                }
            } else {
                EnumFacing rotateAround = facing.func_176732_a(EnumFacing.Axis.Y);
                mat.rotate(1.5707963267948966, rotateAround.func_82601_c(), rotateAround.func_96559_d(), rotateAround.func_82599_e());
            }
            mat.translate(-0.5, -0.5, -0.5);
            ArrayList<BakedQuad> conn = new ArrayList<BakedQuad>(info.model.func_188616_a(null, side, 0L));
            if (side == facing) {
                conn.add(ClientUtils.createBakedQuad(DefaultVertexFormats.field_176599_b, vertices, EnumFacing.UP, info.tex, info.uvs, WHITE, false));
            }
            if ((transf = ApiUtils.transformQuad(mat, null, null)) != null) {
                return conn.stream().map(transf).collect(Collectors.toList());
            }
            return conn;
        }

        @Override
        @Nonnull
        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.quads.get(side == null ? 6 : side.func_176745_a());
        }

        private static /* synthetic */ Integer lambda$init$0(BlockColors colors, FeedthroughCacheKey k, World world, BlockPos pos, Integer i) {
            return colors.func_186724_a(k.baseState, (IBlockAccess)world, pos, i.intValue());
        }
    }

    private static class FeedthroughCacheKey {
        final WireType type;
        final IBlockState baseState;
        final int offset;
        final EnumFacing facing;
        final BlockRenderLayer layer;

        public FeedthroughCacheKey(WireType type, IBlockState baseState, int offset, EnumFacing facing, BlockRenderLayer layer) {
            this.type = type;
            this.baseState = baseState;
            this.offset = offset;
            this.facing = facing;
            this.layer = layer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedthroughCacheKey that = (FeedthroughCacheKey)o;
            return this.offset == that.offset && Objects.equals(this.type, that.type) && Utils.areStatesEqual(this.baseState, that.baseState, (Set<Object>)ImmutableSet.of(), false) && this.facing == that.facing && Objects.equals(this.layer, that.layer);
        }

        public int hashCode() {
            int ret = Utils.hashBlockstate(this.baseState, (Set<Object>)ImmutableSet.of(), false);
            return 31 * ret + Objects.hash(this.type, this.offset, this.facing, this.layer);
        }
    }

    private static class FeedthroughItemOverride
    extends ItemOverrideList {
        private static Cache<ItemStack, FeedthroughModel> ITEM_MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();

        public FeedthroughItemOverride() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            Item connItem = Item.func_150898_a(IEContent.blockConnectors);
            if (stack != null && stack.func_77973_b() == connItem && stack.func_77960_j() == BlockTypes_Connector.FEEDTHROUGH.ordinal()) {
                try {
                    return (IBakedModel)ITEM_MODEL_CACHE.get((Object)stack, () -> new SpecificFeedthroughModel(stack));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return originalModel;
        }
    }
}

