/*
 * Decompiled with CFR 0.152.
 */
package elucent.simplytea.potion;

import net.minecraft.client.Minecraft;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModPotion
extends Potion {
    public static final ResourceLocation POTION_ICONS = new ResourceLocation("simplytea:textures/gui/potions.png");
    private int customIcon = -1;

    public ModPotion(String name, boolean badEffect, int liquidColor) {
        super(badEffect, liquidColor);
        this.setRegistryName(new ResourceLocation("simplytea", name));
        this.func_76390_b(String.format("%s.effect.%s", "simplytea", name));
        if (!badEffect) {
            this.func_188413_j();
        }
    }

    public ModPotion setCustomIcon(int x, int y) {
        this.customIcon = x + 14 * y;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        if (this.customIcon >= 0) {
            mc.func_110434_K().func_110577_a(POTION_ICONS);
            mc.func_181536_a(x + 6, y + 7, this.customIcon % 14 * 18, this.customIcon / 14 * 18, 18, 18, 255, 255, 255, 255);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        if (this.customIcon >= 0) {
            mc.func_110434_K().func_110577_a(POTION_ICONS);
            mc.func_181536_a(x + 3, y + 3, this.customIcon % 14 * 18, this.customIcon / 14 * 18, 18, 18, 255, 255, 255, (int)(alpha * 255.0f));
        }
    }
}

