/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Map;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import openmods.config.game.AbstractFeatureManager;

public class FeatureRegistry {
    public static final FeatureRegistry instance = new FeatureRegistry();
    private Map<String, Entry> features = Maps.newHashMap();

    private void addValue(Entry entry) {
        ModContainer mod = Loader.instance().activeModContainer();
        Preconditions.checkNotNull((Object)mod, (Object)"Can't register outside initialization");
        String modId = mod.getModId();
        Entry prev = this.features.put(modId, entry);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (Object)("Duplicate on modid: " + modId));
    }

    public void register(AbstractFeatureManager manager) {
        this.addValue(new Entry(manager, (Table<String, String, Property>)ImmutableTable.of()));
    }

    public void register(AbstractFeatureManager manager, Table<String, String, Property> properties) {
        Preconditions.checkNotNull(properties);
        this.addValue(new Entry(manager, (Table<String, String, Property>)ImmutableTable.copyOf(properties)));
    }

    public AbstractFeatureManager getManager(String modId) {
        Entry entry = this.features.get(modId);
        if (entry == null) {
            return null;
        }
        return entry.manager;
    }

    public boolean isEnabled(String modId, String category, String feature) {
        Entry entry = this.features.get(modId);
        if (entry == null) {
            return false;
        }
        return entry.manager.isEnabled(category, feature);
    }

    public Property getProperty(String modId, String category, String feature) {
        Entry entry = this.features.get(modId);
        if (entry == null) {
            return null;
        }
        return (Property)entry.properties.get((Object)category, (Object)feature);
    }

    private static class Entry {
        public final AbstractFeatureManager manager;
        public final Table<String, String, Property> properties;

        public Entry(AbstractFeatureManager manager, Table<String, String, Property> properties) {
            this.manager = manager;
            this.properties = properties;
        }
    }
}

