/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.IOneSixMigrationHelper;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.storage.NetworkNodeFluidStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.storage.NetworkNodeStorage;
import com.raoulvdberge.refinedstorage.block.enums.FluidStorageType;
import com.raoulvdberge.refinedstorage.block.enums.ItemStorageType;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class OneSixMigrationHelper
implements IOneSixMigrationHelper {
    private static final String NBT_ITEMS = "Items";
    private static final String NBT_ITEM_TYPE = "Type";
    private static final String NBT_ITEM_QUANTITY = "Quantity";
    private static final String NBT_ITEM_DAMAGE = "Damage";
    private static final String NBT_ITEM_NBT = "NBT";
    private static final String NBT_ITEM_CAPS = "Caps";
    private static final String NBT_FLUIDS = "Fluids";
    private static final String NBT_OUTPUTS = "Outputs";
    private static final String NBT_SLOT = "Slot_%d";
    private static final String NBT_STORAGE = "Storage";

    private static UUID createItemDisk(World world, int capacity, NBTTagCompound legacyTag) {
        UUID id = UUID.randomUUID();
        IStorageDisk<ItemStack> newDisk = API.instance().createDefaultItemDisk(world, capacity);
        NBTTagList list = (NBTTagList)legacyTag.func_74781_a(NBT_ITEMS);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(Item.func_150899_d((int)tag.func_74762_e(NBT_ITEM_TYPE)), tag.func_74762_e(NBT_ITEM_QUANTITY), tag.func_74762_e(NBT_ITEM_DAMAGE), tag.func_74764_b(NBT_ITEM_CAPS) ? tag.func_74775_l(NBT_ITEM_CAPS) : null);
            stack.func_77982_d(tag.func_74764_b(NBT_ITEM_NBT) ? tag.func_74775_l(NBT_ITEM_NBT) : null);
            if (stack.func_190926_b()) continue;
            newDisk.insert(stack, stack.func_190916_E(), Action.PERFORM);
        }
        API.instance().getStorageDiskManager(world).set(id, newDisk);
        API.instance().getStorageDiskManager(world).markForSaving();
        return id;
    }

    private static UUID createFluidDisk(World world, int capacity, NBTTagCompound legacyTag) {
        UUID id = UUID.randomUUID();
        IStorageDisk<FluidStack> newDisk = API.instance().createDefaultFluidDisk(world, capacity);
        NBTTagList list = (NBTTagList)legacyTag.func_74781_a(NBT_FLUIDS);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)list.func_150305_b(i));
            if (stack == null) continue;
            newDisk.insert(stack, stack.amount, Action.PERFORM);
        }
        API.instance().getStorageDiskManager(world).set(id, newDisk);
        API.instance().getStorageDiskManager(world).markForSaving();
        return id;
    }

    @Override
    public boolean migrateDisk(World world, ItemStack disk) {
        IStorageDiskProvider provider = (IStorageDiskProvider)disk.func_77973_b();
        switch (provider.getType()) {
            case ITEM: {
                if (!disk.func_77942_o() || !disk.func_77978_p().func_74764_b(NBT_ITEMS)) break;
                provider.setId(disk, OneSixMigrationHelper.createItemDisk(world, provider.getCapacity(disk), disk.func_77978_p()));
                return true;
            }
            case FLUID: {
                if (!disk.func_77942_o() || !disk.func_77978_p().func_74764_b(NBT_FLUIDS)) break;
                provider.setId(disk, OneSixMigrationHelper.createFluidDisk(world, provider.getCapacity(disk), disk.func_77978_p()));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean migrateDiskInventory(World world, IItemHandlerModifiable handler) {
        boolean migrated = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack disk = handler.getStackInSlot(i);
            if (disk.func_190926_b() || !(disk.func_77973_b() instanceof IStorageDiskProvider) || !this.migrateDisk(world, disk)) continue;
            handler.setStackInSlot(i, disk);
            migrated = true;
        }
        return migrated;
    }

    @Override
    public boolean migratePattern(ItemStack pattern) {
        NBTTagCompound tag = pattern.func_77978_p();
        if (pattern.func_77942_o() && !tag.func_74764_b("Processing")) {
            boolean isProcessing = tag.func_74764_b(NBT_OUTPUTS);
            tag.func_74757_a("Processing", isProcessing);
            for (int i = 0; i < 9; ++i) {
                String id = String.format(NBT_SLOT, i);
                if (!tag.func_74764_b(id)) continue;
                ItemStack slot = new ItemStack(pattern.func_77978_p().func_74775_l(id));
                if (!slot.func_190926_b()) {
                    tag.func_74782_a(String.format("Input_%d", i), (NBTBase)slot.serializeNBT());
                }
                tag.func_82580_o(id);
            }
            if (isProcessing) {
                NBTTagList list = tag.func_150295_c(NBT_OUTPUTS, 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    ItemStack output = new ItemStack(list.func_150305_b(i));
                    if (output.func_190926_b()) continue;
                    tag.func_74782_a(String.format("Output_%d", i), (NBTBase)output.serializeNBT());
                }
                tag.func_82580_o(NBT_OUTPUTS);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean migratePatternInventory(IItemHandler handler) {
        boolean migrated = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack pattern = handler.getStackInSlot(i);
            if (pattern.func_190926_b() || !this.migratePattern(pattern)) continue;
            migrated = true;
        }
        return migrated;
    }

    public static boolean isValidOneSixPattern(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Processing");
    }

    public static void removalHook() {
    }

    public static void migrateEmptyWhitelistToEmptyBlacklist(String version, IFilterable filterable, @Nullable ItemHandlerBase itemFilterInv) {
        if (version == null && filterable.getMode() == 0 && (itemFilterInv == null || itemFilterInv.isEmpty())) {
            filterable.setMode(1);
        }
    }

    public static void migrateItemStorageBlock(NetworkNodeStorage storage, NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_STORAGE)) {
            NBTTagCompound storageTag = tag.func_74775_l(NBT_STORAGE);
            storage.setStorageId(OneSixMigrationHelper.createItemDisk(storage.getWorld(), storage.getType().getCapacity(), storageTag));
            storage.loadStorage();
        }
    }

    public static void migrateItemStorageBlockItem(World world, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_STORAGE)) {
            NBTTagCompound storageTag = stack.func_77978_p().func_74775_l(NBT_STORAGE);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_186854_a("Id", OneSixMigrationHelper.createItemDisk(world, ItemStorageType.getById(stack.func_77952_i()).getCapacity(), storageTag));
        }
    }

    public static void migrateFluidStorageBlock(NetworkNodeFluidStorage storage, NBTTagCompound tag) {
        if (tag.func_74764_b(NBT_STORAGE)) {
            NBTTagCompound storageTag = tag.func_74775_l(NBT_STORAGE);
            storage.setStorageId(OneSixMigrationHelper.createFluidDisk(storage.getWorld(), storage.getType().getCapacity(), storageTag));
            storage.loadStorage();
        }
    }

    public static void migrateFluidStorageBlockItem(World world, ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_STORAGE)) {
            NBTTagCompound storageTag = stack.func_77978_p().func_74775_l(NBT_STORAGE);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_186854_a("Id", OneSixMigrationHelper.createFluidDisk(world, FluidStorageType.getById(stack.func_77952_i()).getCapacity(), storageTag));
        }
    }
}

