/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import noppes.vc.VCBlocks;
import noppes.vc.blocks.tiles.TileBanner;
import noppes.vc.shared.util.AnalyticsTracking;

public class ServerEventsHandler {
    private String serverName = null;

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(player.field_70170_p.field_72995_K || block != VCBlocks.banner && block != VCBlocks.wall_banner && block != VCBlocks.sign)) {
            TileBanner tile;
            ItemStack item = player.field_71071_by.func_70448_g();
            if (item == null || item.func_77973_b() == null) {
                return;
            }
            int meta = block.func_176201_c(state);
            if (meta >= 7) {
                pos = pos.func_177977_b();
            }
            if (!(tile = (TileBanner)player.field_70170_p.func_175625_s(pos)).canEdit()) {
                return;
            }
            if (!player.field_70170_p.field_72995_K) {
                tile.icon = item.func_77946_l();
                tile.func_70296_d();
                player.field_70170_p.func_184138_a(pos, state, state, 3);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.serverName == null) {
            String e = "local";
            MinecraftServer server = event.player.func_184102_h();
            if (server.func_71262_S()) {
                try {
                    e = InetAddress.getByName(server.func_71211_k()).getCanonicalHostName();
                }
                catch (UnknownHostException e1) {
                    e = server.func_71211_k();
                }
                if (server.func_71215_F() != 25565) {
                    e = e + ":" + server.func_71215_F();
                }
            }
            if (e == null || e.startsWith("192.168") || e.contains("127.0.0.1") || e.startsWith("localhost")) {
                e = "local";
            }
            this.serverName = e;
        }
        AnalyticsTracking.sendData(event.player, "join", this.serverName, "variedcommodities", "1.12");
    }
}

