/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.world;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.world.gen.SpongeChunkGenerator;
import org.spongepowered.common.world.gen.SpongeWorldGenerator;
import org.spongepowered.mod.mixin.core.world.WorldMixin_Forge;
import org.spongepowered.mod.world.gen.SpongeChunkGeneratorForge;

@Mixin(value={WorldServer.class}, priority=1001)
public abstract class WorldServerMixin_Forge
extends WorldMixin_Forge
implements WorldServerBridge {
    @Override
    public int bridge$getDimensionId() {
        return this.field_73011_w.getDimension();
    }

    @Override
    protected void forgeImpl$UseComparatorOutputLevel(World world, BlockPos pos, Block blockIn, BlockPos samePos) {
        if (!((WorldBridge)((Object)this)).bridge$isFake() && PhaseTracker.getInstance().getCurrentState().isRestoring()) {
            return;
        }
        this.func_175666_e(pos, blockIn);
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraftforge/common/DimensionManager;setWorld(ILnet/minecraft/world/WorldServer;Lnet/minecraft/server/MinecraftServer;)V", remap=false))
    private void redirectSetWorld(int id, WorldServer world, MinecraftServer server) {
    }

    @Redirect(method={"canMineBlockBody"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;isBlockProtected(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/EntityPlayer;)Z"))
    private boolean isSpongeBlockProtected(MinecraftServer server, World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (server.func_175579_a(worldIn, pos, playerIn)) {
            return true;
        }
        if (!((WorldBridge)((Object)this)).bridge$isFake() && SpongeImplHooks.isMainThread()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(playerIn.func_184607_cu()));
                boolean bl = SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)this, pos, (Object)playerIn).isCancelled();
                return bl;
            }
        }
        return false;
    }

    @Override
    @Overwrite
    public boolean func_175660_a(EntityPlayer player, BlockPos pos) {
        if (super.func_175660_a(player, pos)) {
            return true;
        }
        if (!((WorldBridge)((Object)this)).bridge$isFake() && SpongeImplHooks.isMainThread()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.USED_ITEM, ItemStackUtil.snapshotOf(player.func_184607_cu()));
                boolean bl = !SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)this, pos, (Object)player).isCancelled();
                return bl;
            }
        }
        return false;
    }

    @Override
    public void bridge$setProviderGenerator(SpongeChunkGenerator newGenerator) {
    }

    @Override
    public SpongeChunkGenerator bridge$createChunkGenerator(SpongeWorldGenerator newGenerator) {
        return new SpongeChunkGeneratorForge((World)this, newGenerator.getBaseGenerationPopulator(), newGenerator.getBiomeGenerator());
    }

    @Override
    int vanillaImpl$updateRainTimeStart(int newRainTime) {
        if (!((WorldBridge)((Object)this)).bridge$isFake() && this.field_72986_A.func_76083_p() - 1 != newRainTime) {
            this.bridge$setWeatherStartTime(this.func_82737_E());
        }
        return newRainTime;
    }

    @Override
    int vanillaImpl$updateThunderTimeStart(int newThunderTime) {
        if (!((WorldBridge)((Object)this)).bridge$isFake() && this.field_72986_A.func_76071_n() - 1 != newThunderTime) {
            this.bridge$setWeatherStartTime(this.func_82737_E());
        }
        return newThunderTime;
    }
}

