/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.block;

import java.util.Random;
import net.minecraft.block.BlockFire;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={BlockFire.class})
public abstract class BlockFireMixin_Forge
extends BlockMixin {
    @Inject(method={"tryCatchFire"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z")}, cancellable=true)
    private void onCatchFirePreCheck(World world, BlockPos pos, int chance, Random random, int age, EnumFacing facing, CallbackInfo callbackInfo) {
        if (!world.field_72995_K) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.FIRE_SPREAD, (org.spongepowered.api.world.World)world);
                if (SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
                    callbackInfo.cancel();
                }
            }
        }
    }

    @Inject(method={"tryCatchFire"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockToAir(Lnet/minecraft/util/math/BlockPos;)Z")}, cancellable=true)
    private void onCatchFirePreCheckOther(World world, BlockPos pos, int chance, Random random, int age, EnumFacing facing, CallbackInfo callbackInfo) {
        if (!world.field_72995_K) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.FIRE_SPREAD, (org.spongepowered.api.world.World)world);
                if (SpongeCommonEventFactory.callChangeBlockEventPre((WorldServerBridge)world, pos).isCancelled()) {
                    callbackInfo.cancel();
                }
            }
        }
    }
}

