/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.api.fml.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.ModMetadata;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.mod.plugin.DependencyHandler;
import org.spongepowered.plugin.meta.PluginDependency;

@Mixin(value={ModContainer.class})
public interface ModContainerMixin_ForgeAPI
extends PluginContainer {
    @Shadow
    public String shadow$getVersion();

    @Shadow
    public String shadow$getModId();

    @Shadow
    public ModMetadata shadow$getMetadata();

    @Shadow
    public File shadow$getSource();

    @Shadow
    public Object getMod();

    @Override
    default public String getId() {
        return (String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.shadow$getModId()), (Object)"modid");
    }

    @Override
    default public Optional<String> getVersion() {
        String version = Strings.emptyToNull((String)this.shadow$getVersion());
        if (version != null && ("unknown".equalsIgnoreCase(version) || "dev".equalsIgnoreCase(version))) {
            version = null;
        }
        return Optional.ofNullable(version);
    }

    @Override
    default public Optional<String> getDescription() {
        ModMetadata meta = this.shadow$getMetadata();
        return meta != null ? Optional.ofNullable(Strings.emptyToNull((String)meta.description)) : Optional.empty();
    }

    @Override
    default public Optional<String> getUrl() {
        ModMetadata meta = this.shadow$getMetadata();
        return meta != null ? Optional.ofNullable(Strings.emptyToNull((String)meta.url)) : Optional.empty();
    }

    @Override
    default public List<String> getAuthors() {
        ModMetadata meta = this.shadow$getMetadata();
        return meta != null ? ImmutableList.copyOf((Collection)meta.authorList) : ImmutableList.of();
    }

    @Override
    default public Set<PluginDependency> getDependencies() {
        return DependencyHandler.collectDependencies((ModContainer)this);
    }

    @Override
    default public Optional<PluginDependency> getDependency(String id) {
        return Optional.ofNullable(DependencyHandler.findDependency((ModContainer)this, id));
    }

    @Override
    default public Optional<Path> getSource() {
        File source = this.shadow$getSource();
        if (source != null) {
            return Optional.of(source.toPath());
        }
        return Optional.empty();
    }

    @Override
    default public Optional<?> getInstance() {
        return Optional.ofNullable(this.getMod());
    }
}

