/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.apache.commons.io.FileUtils;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.file.CopyFileVisitor;
import org.spongepowered.common.SpongeImpl;

public final class WorldMigrator {
    public static Path getOldWorldContainer() {
        Path worldContainer = Paths.get(".", new String[0]);
        Path bukkitYml = worldContainer.resolve("bukkit.yml");
        if (Files.exists(bukkitYml, new LinkOption[0])) {
            try {
                Object node = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(bukkitYml)).build().load();
                String containerCandidate = node.getNode("settings", "world-container").getString("");
                if (!containerCandidate.isEmpty()) {
                    try {
                        worldContainer = Paths.get(worldContainer.toString(), new String[0]).resolve(containerCandidate);
                    }
                    catch (InvalidPathException ipe) {
                        SpongeImpl.getLogger().warn("Cannot use path [{}] specified under [world-container] in bukkit.yml. Will use [{}] instead.", (Object)containerCandidate, (Object)worldContainer, (Object)ipe);
                    }
                }
            }
            catch (IOException ioe) {
                SpongeImpl.getLogger().warn("Cannot load bukkit.yml. Will use [{}] instead.", (Object)worldContainer, (Object)ioe);
            }
        }
        return worldContainer;
    }

    public static void migrateWorldsTo(Path worldContainer) {
        SpongeImpl.getLogger().info("Checking for worlds that need to be migrated...");
        Path oldWorldContainer = WorldMigrator.getOldWorldContainer();
        ArrayList<Path> migrated = new ArrayList<Path>();
        if (Files.exists(oldWorldContainer, new LinkOption[0])) {
            try (DirectoryStream<Path> stream2 = Files.newDirectoryStream(oldWorldContainer, entry -> !entry.getFileName().equals(worldContainer.getFileName()) && Files.exists(entry.resolve("level.dat"), new LinkOption[0]) && !Files.exists(entry.resolve("level_sponge.dat"), new LinkOption[0]));){
                for (Path oldWorldPath : stream2) {
                    Path worldPath = worldContainer.resolve(WorldMigrator.getVanillaNetherOrEndName(oldWorldPath));
                    if (!Files.notExists(worldPath, new LinkOption[0])) continue;
                    SpongeImpl.getLogger().info("Migrating [{}] from [{}].", (Object)oldWorldPath.getFileName(), (Object)oldWorldContainer);
                    try {
                        worldPath = WorldMigrator.renameToVanillaNetherOrEnd(worldContainer, oldWorldPath, worldPath);
                        Files.walkFileTree(oldWorldPath, new CopyFileVisitor(worldPath, new CopyOption[0]));
                        WorldMigrator.fixInnerNetherOrEndRegionData(worldPath);
                        WorldMigrator.removeInnerNameFolder(worldPath);
                        migrated.add(worldPath);
                    }
                    catch (IOException ioe) {
                        SpongeImpl.getLogger().warn("Failed to migrate [{}] from [{}] to [{}]", (Object)oldWorldPath.getFileName(), (Object)oldWorldContainer, (Object)worldPath, (Object)ioe);
                    }
                    SpongeImpl.getLogger().info("Migrated world [{}] from [{}] to [{}]", (Object)oldWorldPath.getFileName(), (Object)oldWorldContainer, (Object)worldPath);
                }
            }
            catch (Exception stream2) {
                // empty catch block
            }
            if (!migrated.isEmpty()) {
                SpongeImpl.getLogger().info("[{}] worlds have been migrated back to Vanilla's format.", (Object)migrated.size());
            } else {
                SpongeImpl.getLogger().info("No worlds were found in need of migration.");
            }
        }
        if (Sponge.getPlatform().getType().isClient()) {
            try {
                Files.newDirectoryStream(worldContainer.getParent()).forEach(saveFolder -> {
                    boolean isWorld = Files.exists(saveFolder.resolve("level.dat"), new LinkOption[0]);
                    if (isWorld) {
                        final Path invalidSaveDataFolder = saveFolder.getParent().getParent().resolve(saveFolder.getFileName().toString());
                        try {
                            if (Files.isDirectory(invalidSaveDataFolder, new LinkOption[0])) {
                                Files.walkFileTree(invalidSaveDataFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                        if (invalidSaveDataFolder != dir) {
                                            Path validFile = null;
                                            for (int i = 2; i < dir.getNameCount(); ++i) {
                                                validFile = validFile == null ? saveFolder.resolve(dir.getName(i)) : validFile.resolve(dir.getName(i));
                                            }
                                            if (validFile != null && Files.notExists(validFile, new LinkOption[0])) {
                                                Files.createDirectories(validFile, new FileAttribute[0]);
                                            }
                                        }
                                        return super.preVisitDirectory(dir, attrs);
                                    }

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        if (!Files.isDirectory(file, new LinkOption[0])) {
                                            Path validFile = null;
                                            for (int i = 2; i < file.getNameCount(); ++i) {
                                                validFile = validFile == null ? saveFolder.resolve(file.getName(i)) : validFile.resolve(file.getName(i));
                                            }
                                            if (validFile != null && Files.notExists(validFile, new LinkOption[0])) {
                                                com.google.common.io.Files.move((File)file.toFile(), (File)validFile.toFile());
                                            }
                                        }
                                        return super.visitFile(file, attrs);
                                    }
                                });
                                FileUtils.deleteDirectory((File)invalidSaveDataFolder.toFile());
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isValidBukkitNetherOrEnd(Path worldContainer, Path oldWorldPath) {
        return oldWorldPath.getFileName().toString().startsWith(worldContainer.getFileName().toString()) && (oldWorldPath.getFileName().toString().endsWith("_nether") || oldWorldPath.getFileName().toString().endsWith("_the_end"));
    }

    private static String getVanillaNetherOrEndName(Path worldPath) {
        String newName = worldPath.getFileName().toString();
        if (newName.endsWith("_nether")) {
            return "DIM-1";
        }
        if (newName.endsWith("_the_end")) {
            return "DIM1";
        }
        return newName;
    }

    private static Path renameToVanillaNetherOrEnd(Path worldContainer, Path oldWorldPath, Path worldPath) {
        String newName = WorldMigrator.getVanillaNetherOrEndName(oldWorldPath);
        Path newWorldPath = worldContainer.resolve(newName);
        if (WorldMigrator.isValidBukkitNetherOrEnd(worldContainer, oldWorldPath) && Files.notExists(worldContainer.resolve(newName), new LinkOption[0])) {
            return newWorldPath;
        }
        return worldPath;
    }

    private static void fixInnerNetherOrEndRegionData(Path oldWorldPath) {
        try {
            com.google.common.io.Files.move((File)oldWorldPath.resolve("DIM-1").resolve("region").toFile(), (File)oldWorldPath.resolve("region").toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            com.google.common.io.Files.move((File)oldWorldPath.resolve("DIM1").resolve("region").toFile(), (File)oldWorldPath.resolve("region").toFile());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void removeInnerNameFolder(Path worldPath) {
        try {
            Files.deleteIfExists(worldPath.resolve("DIM-1"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.deleteIfExists(worldPath.resolve("DIM1"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

