/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.relocate.co.aikar.timings;

import co.aikar.timings.Timing;
import java.util.ArrayDeque;
import java.util.Map;
import org.spongepowered.common.relocate.co.aikar.timings.TimingHandler;
import org.spongepowered.common.relocate.co.aikar.util.LoadingMap;
import org.spongepowered.common.relocate.co.aikar.util.MRUMapCache;

final class TimingIdentifier {
    static final Map<String, TimingGroup> GROUP_MAP = MRUMapCache.of(LoadingMap.newIdentityHashMap(TimingGroup::new, 64));
    static final TimingGroup DEFAULT_GROUP = TimingIdentifier.getGroup("Minecraft");
    final String group;
    final String name;
    final TimingHandler groupHandler;
    final boolean protect;
    private final int hashCode;

    TimingIdentifier(String group, String name, Timing groupHandler, boolean protect) {
        this.group = group != null ? group.intern() : TimingIdentifier.DEFAULT_GROUP.name;
        this.name = name.intern();
        this.groupHandler = groupHandler instanceof TimingHandler ? (TimingHandler)groupHandler : null;
        this.protect = protect;
        this.hashCode = 31 * this.group.hashCode() + this.name.hashCode();
    }

    static TimingGroup getGroup(String groupName) {
        if (groupName == null) {
            return DEFAULT_GROUP;
        }
        return GROUP_MAP.get(groupName.intern());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TimingIdentifier)) {
            return false;
        }
        TimingIdentifier that = (TimingIdentifier)o;
        return this.group == that.group && this.name == that.name;
    }

    public int hashCode() {
        return this.hashCode;
    }

    static class TimingGroup {
        private static int idPool = 1;
        final int id = idPool++;
        final String name;
        ArrayDeque<TimingHandler> handlers = new ArrayDeque(64);

        TimingGroup(String name) {
            this.name = name;
        }
    }
}

