/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import com.google.common.base.Preconditions;
import net.minecraft.item.Item;
import org.spongepowered.api.GameDictionary;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;

public interface SpongeGameDictionaryEntry
extends GameDictionary.Entry {
    public net.minecraft.item.ItemStack bridge$createDictionaryStack(int var1);

    public static SpongeGameDictionaryEntry of(net.minecraft.item.ItemStack stack, int wildcardValue) {
        if (stack.func_77952_i() == wildcardValue) {
            return (SpongeGameDictionaryEntry)stack.func_77973_b();
        }
        return new Specific(stack.func_77973_b(), stack.func_77952_i());
    }

    public static final class Specific
    implements SpongeGameDictionaryEntry {
        private final Item type;
        private final int damage;

        public Specific(Item type, int damage) {
            this.type = (Item)Preconditions.checkNotNull((Object)type, (Object)"type");
            this.damage = damage;
        }

        @Override
        public ItemType getType() {
            return (ItemType)this.type;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return this.getType().equals(stack.getType()) && this.damage == ((net.minecraft.item.ItemStack)stack).func_77952_i();
        }

        @Override
        public boolean isSpecific() {
            return true;
        }

        @Override
        public net.minecraft.item.ItemStack bridge$createDictionaryStack(int wildcardValue) {
            return new net.minecraft.item.ItemStack(this.type, 1, this.damage);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.damage;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Specific)) {
                return false;
            }
            Specific other = (Specific)obj;
            if (!this.type.equals(other.type)) {
                return false;
            }
            return this.damage == other.damage;
        }

        @Override
        public ItemStackSnapshot getTemplate() {
            return ((ItemStack)new net.minecraft.item.ItemStack(this.type, 1, this.damage)).createSnapshot();
        }
    }
}

