/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import co.aikar.timings.Timing;
import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.bridge.world.chunk.ActiveChunkReferantBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.data.type.SpongeTileEntityType;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.registry.type.block.TileEntityTypeRegistryModule;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;

@Mixin(value={TileEntity.class})
abstract class TileEntityMixin
implements TileEntityBridge,
DataCompoundHolder,
TimingBridge,
TrackableBridge {
    @Nullable
    private Timing impl$timing;
    private boolean impl$isTicking = false;
    private boolean impl$allowsBlockBulkCapture = true;
    private boolean impl$allowsEntityBulkCapture = true;
    private boolean impl$allowsBlockEventCreation = true;
    private boolean impl$allowsEntityEventCreation = true;
    private boolean impl$isCaptured = false;
    @Shadow
    protected World field_145850_b;
    @Shadow
    private int field_145847_g;
    @Shadow
    protected BlockPos field_174879_c;

    TileEntityMixin() {
    }

    @Shadow
    public abstract BlockPos func_174877_v();

    @Shadow
    public abstract Block func_145838_q();

    @Shadow
    public abstract NBTTagCompound func_189515_b(NBTTagCompound var1);

    @Shadow
    public abstract void shadow$func_70296_d();

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void impl$RefreshTrackerStates(CallbackInfo ci) {
        this.bridge$refreshTrackerStates();
    }

    @Inject(method={"register(Ljava/lang/String;Ljava/lang/Class;)V"}, at={@At(value="RETURN")})
    private static void impl$registerTileEntityClassWithSpongeRegistry(String name, @Nullable Class clazz, CallbackInfo callbackInfo) {
        if (clazz != null) {
            TileEntityTypeRegistryModule.getInstance().doTileEntityRegistration(clazz, name);
        }
    }

    @Inject(method={"invalidate"}, at={@At(value="RETURN")})
    private void impl$RemoveActiveChunkOnInvalidate(CallbackInfo ci) {
        ((ActiveChunkReferantBridge)((Object)this)).bridge$setActiveChunk(null);
    }

    @Inject(method={"writeToNBT(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;"}, at={@At(value="HEAD")})
    private void impl$WriteSpongeDataToCompound(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> ci) {
        if (!((CustomDataHolderBridge)((Object)this)).bridge$getCustomManipulators().isEmpty()) {
            this.bridge$writeToSpongeCompound(this.data$getSpongeCompound());
        }
    }

    @Inject(method={"readFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V"}, at={@At(value="RETURN")})
    private void impl$ReadSpongeDataFromCompound(NBTTagCompound compound, CallbackInfo ci) {
        if (this.data$hasRootCompound()) {
            this.bridge$readFromSpongeCompound(this.data$getSpongeCompound());
        }
    }

    protected void bridge$readFromSpongeCompound(NBTTagCompound compound) {
        DataUtil.readCustomData(compound, (org.spongepowered.api.block.tileentity.TileEntity)((Object)this));
    }

    protected void bridge$writeToSpongeCompound(NBTTagCompound compound) {
        DataUtil.writeCustomData(compound, (org.spongepowered.api.block.tileentity.TileEntity)((Object)this));
    }

    @Override
    public Timing bridge$getTimingsHandler() {
        if (this.impl$timing == null) {
            this.impl$timing = SpongeTimings.getTileEntityTiming((org.spongepowered.api.block.tileentity.TileEntity)((Object)this));
        }
        return this.impl$timing;
    }

    @Override
    public boolean bridge$shouldTick() {
        ChunkBridge chunk = ((ActiveChunkReferantBridge)((Object)this)).bridge$getActiveChunk();
        if (chunk == null) {
            return false;
        }
        return chunk.bridge$isActive();
    }

    @Override
    public boolean bridge$allowsBlockBulkCapture() {
        return this.impl$allowsBlockBulkCapture;
    }

    @Override
    public boolean bridge$allowsEntityBulkCapture() {
        return this.impl$allowsEntityBulkCapture;
    }

    @Override
    public boolean bridge$allowsBlockEventCreation() {
        return this.impl$allowsBlockEventCreation;
    }

    @Override
    public boolean bridge$allowsEntityEventCreation() {
        return this.impl$allowsEntityEventCreation;
    }

    @Override
    public boolean bridge$isCaptured() {
        return this.impl$isCaptured;
    }

    @Override
    public void bridge$setCaptured(boolean captured) {
        this.impl$isCaptured = captured;
    }

    @Override
    public void bridge$refreshTrackerStates() {
        if (((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType() != null) {
            this.impl$allowsBlockBulkCapture = ((SpongeTileEntityType)((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType()).allowsBlockBulkCapture;
            this.impl$allowsEntityBulkCapture = ((SpongeTileEntityType)((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType()).allowsEntityBulkCapture;
            this.impl$allowsBlockEventCreation = ((SpongeTileEntityType)((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType()).allowsBlockEventCreation;
            this.impl$allowsEntityEventCreation = ((SpongeTileEntityType)((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType()).allowsEntityEventCreation;
        }
    }

    public String toString() {
        TileEntityType type = ((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType();
        return MoreObjects.toStringHelper((Object)this).add("tileType", type == null ? this.getClass() : type.getId()).add("world", (Object)this.field_145850_b).add("pos", (Object)this.field_174879_c).add("blockMetadata", this.field_145847_g).toString();
    }

    protected MoreObjects.ToStringHelper getPrettyPrinterStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)((org.spongepowered.api.block.tileentity.TileEntity)((Object)this)).getType().getId()).add("world", (Object)this.field_145850_b.func_72912_H().func_76065_j()).add("pos", (Object)this.field_174879_c);
    }

    @Override
    public String bridge$getPrettyPrinterString() {
        return this.getPrettyPrinterStringHelper().toString();
    }
}

