/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.tileentity;

import java.util.Collections;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.carrier.Furnace;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.tileentity.SmeltEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.Surrogate;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.CustomNameableBridge;
import org.spongepowered.common.item.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.FuelSlotAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.InputSlotAdapter;
import org.spongepowered.common.item.inventory.adapter.impl.slots.OutputSlotAdapter;
import org.spongepowered.common.item.inventory.lens.Fabric;
import org.spongepowered.common.item.inventory.lens.SlotProvider;
import org.spongepowered.common.item.inventory.lens.impl.ReusableLens;
import org.spongepowered.common.item.inventory.lens.impl.collections.SlotCollection;
import org.spongepowered.common.item.inventory.lens.impl.minecraft.FurnaceInventoryLens;
import org.spongepowered.common.item.inventory.lens.impl.slots.FuelSlotLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.InputSlotLensImpl;
import org.spongepowered.common.item.inventory.lens.impl.slots.OutputSlotLensImpl;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.tileentity.TileEntityLockableMixin;

@Mixin(value={TileEntityFurnace.class})
public abstract class TileEntityFurnaceMixin
extends TileEntityLockableMixin
implements CustomNameableBridge {
    @Shadow
    private NonNullList<net.minecraft.item.ItemStack> field_145957_n;
    @Shadow
    private int field_174906_k;
    @Shadow
    private int field_145963_i;

    @Shadow
    protected abstract boolean func_145948_k();

    @Override
    public ReusableLens<?> bridge$generateReusableLens(Fabric fabric, InventoryAdapter adapter) {
        return ReusableLens.getLens(FurnaceInventoryLens.class, this, this::impl$generateSlotProvider, this::impl$generateRootLens);
    }

    private SlotProvider impl$generateSlotProvider() {
        return new SlotCollection.Builder().add(InputSlotAdapter.class, InputSlotLensImpl::new).add(FuelSlotAdapter.class, i -> new FuelSlotLensImpl(i, s -> TileEntityFurnace.func_145954_b((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)s)) || SlotFurnaceFuel.func_178173_c_((net.minecraft.item.ItemStack)((net.minecraft.item.ItemStack)s)), t -> {
            net.minecraft.item.ItemStack nmsStack = (net.minecraft.item.ItemStack)ItemStack.of(t, 1);
            return TileEntityFurnace.func_145954_b((net.minecraft.item.ItemStack)nmsStack) || SlotFurnaceFuel.func_178173_c_((net.minecraft.item.ItemStack)nmsStack);
        })).add(OutputSlotAdapter.class, i -> new OutputSlotLensImpl(i, s -> true, t -> true)).build();
    }

    private FurnaceInventoryLens impl$generateRootLens(SlotProvider slots) {
        return new FurnaceInventoryLens(this, slots);
    }

    @Override
    public void bridge$setCustomDisplayName(String customName) {
        ((TileEntityFurnace)this).func_145951_a(customName);
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V"))
    private void impl$throwFuelEventIfOrShrink(net.minecraft.item.ItemStack itemStack, int quantity) {
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf(itemStack);
        ItemStackSnapshot shrinkedFuel = ItemStackUtil.snapshotOf(ItemStackUtil.cloneDefensive(itemStack, itemStack.func_190916_E() - 1));
        Transaction<ItemStackSnapshot> transaction = new Transaction<ItemStackSnapshot>(fuel, shrinkedFuel);
        SmeltEvent.ConsumeFuel event = SpongeEventFactory.createSmeltEventConsumeFuel(cause, fuel, (Furnace)((Object)this), Collections.singletonList(transaction));
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            this.field_145963_i = 0;
            return;
        }
        if (!transaction.isValid()) {
            return;
        }
        if (transaction.getCustom().isPresent()) {
            this.field_145957_n.set(1, (Object)ItemStackUtil.fromSnapshotToNative(transaction.getFinal()));
        } else {
            itemStack.func_190918_g(quantity);
        }
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityFurnace;canSmelt()Z", ordinal=1))
    private boolean impl$checkIfCanSmelt(TileEntityFurnace furnace) {
        if (!this.func_145948_k()) {
            return false;
        }
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((net.minecraft.item.ItemStack)this.field_145957_n.get(1));
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        if (this.field_174906_k == 0) {
            SmeltEvent.Start event = SpongeEventFactory.createSmeltEventStart(cause, fuel, (Furnace)((Object)this), Collections.emptyList());
            SpongeImpl.postEvent(event);
            return !event.isCancelled();
        }
        SmeltEvent.Tick event = SpongeEventFactory.createSmeltEventTick(cause, fuel, (Furnace)((Object)this), Collections.emptyList());
        SpongeImpl.postEvent(event);
        return !event.isCancelled();
    }

    @Redirect(method={"update"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))
    private int impl$resetCookTimeIfCancelled(int newCookTime, int zero, int totalCookTime) {
        int clampedCookTime = MathHelper.func_76125_a((int)newCookTime, (int)zero, (int)totalCookTime);
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((net.minecraft.item.ItemStack)this.field_145957_n.get(1));
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        SmeltEvent.Tick event = SpongeEventFactory.createSmeltEventTick(cause, fuel, (Furnace)((Object)this), Collections.emptyList());
        SpongeImpl.postEvent(event);
        if (event.isCancelled()) {
            return this.field_174906_k;
        }
        return clampedCookTime;
    }

    @Inject(method={"setInventorySlotContents"}, at={@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityFurnace;getCookTime(Lnet/minecraft/item/ItemStack;)I")})
    private void impl$interruptSmelt(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    @Inject(method={"update"}, at={@At(shift=At.Shift.BEFORE, value="FIELD", opcode=181, target="Lnet/minecraft/tileentity/TileEntityFurnace;cookTime:I")}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/tileentity/TileEntityFurnace;smeltItem()V"), to=@At(value="INVOKE", target="Lnet/minecraft/util/math/MathHelper;clamp(III)I"))})
    private void impl$onResetCookTimePassive(CallbackInfo ci) {
        this.impl$callInteruptSmeltEvent();
    }

    private void impl$callInteruptSmeltEvent() {
        if (this.field_174906_k > 0) {
            ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((net.minecraft.item.ItemStack)this.field_145957_n.get(1));
            Cause cause = Sponge.getCauseStackManager().getCurrentCause();
            SmeltEvent.Interrupt event = SpongeEventFactory.createSmeltEventInterrupt(cause, fuel, Collections.emptyList(), (Furnace)((Object)this));
            SpongeImpl.postEvent(event);
        }
    }

    @Inject(method={"smeltItem"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;shrink(I)V")})
    private void impl$afterSmeltItem(CallbackInfo ci, net.minecraft.item.ItemStack itemStack, net.minecraft.item.ItemStack result, net.minecraft.item.ItemStack outputStack) {
        this.impl$callSmeltFinish(result);
    }

    @Surrogate
    private void impl$afterSmeltItem(CallbackInfo ci, net.minecraft.item.ItemStack outputStack) {
        this.impl$callSmeltFinish(FurnaceRecipes.func_77602_a().func_151395_a((net.minecraft.item.ItemStack)this.field_145957_n.get(0)));
    }

    private void impl$callSmeltFinish(net.minecraft.item.ItemStack result) {
        ItemStackSnapshot fuel = ItemStackUtil.snapshotOf((net.minecraft.item.ItemStack)this.field_145957_n.get(1));
        Cause cause = Sponge.getCauseStackManager().getCurrentCause();
        ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(result);
        SmeltEvent.Finish event = SpongeEventFactory.createSmeltEventFinish(cause, fuel, Collections.singletonList(snapshot), (Furnace)((Object)this));
        SpongeImpl.postEvent(event);
    }
}

