/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.block.state;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.util.Constants;

@Mixin(targets={"net.minecraft.block.state.BlockStateContainer$StateImplementation"})
public abstract class StateImplementationMixin_API
extends BlockStateBase
implements BlockState {
    @Shadow
    @Final
    private Block field_177239_a;
    @Shadow
    @Final
    private ImmutableMap<IProperty<?>, Comparable<?>> field_177237_b;
    @Nullable
    private ImmutableSet<ImmutableValue<?>> api$values;
    @Nullable
    private ImmutableSet<Key<?>> api$keys;
    @Nullable
    private ImmutableList<ImmutableDataManipulator<?, ?>> api$manipulators;
    @Nullable
    private ImmutableMap<Key<?>, Object> api$keyMap;
    @Nullable
    private ImmutableMap<Class<? extends Property<?, ?>>, Property<?, ?>> api$dataProperties;
    @Nullable
    private String api$id;

    @Override
    public BlockState cycleValue(Key<? extends BaseValue<? extends Cycleable<?>>> key) {
        Optional optional = this.get(key);
        return optional.map(Cycleable::cycleNext).map(newVal -> {
            BlockState o = null;
            try {
                o = this.with(key, newVal).orElseThrow(() -> new IllegalStateException("Unable to retrieve a cycled BlockState for key: " + key + " and value: " + newVal));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return o;
        }).orElseThrow(() -> new IllegalArgumentException("Used an invalid cycleable key! Check with supports in the future!"));
    }

    @Override
    public BlockSnapshot snapshotFor(Location<World> location) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().blockState((IBlockState)this).position(location.getBlockPosition()).worldId(location.getExtent().getUniqueId());
        if (this.field_177239_a.func_149716_u() && location.getBlockType().equals(this.field_177239_a)) {
            org.spongepowered.api.block.tileentity.TileEntity tileEntity = location.getTileEntity().orElseThrow(() -> new IllegalStateException("Unable to retrieve a TileEntity for location: " + location));
            for (DataManipulator<?, ?> manipulator : ((CustomDataHolderBridge)((Object)tileEntity)).bridge$getCustomManipulators()) {
                builder.add((DataManipulator)manipulator);
            }
            NBTTagCompound compound = new NBTTagCompound();
            ((TileEntity)tileEntity).func_189515_b(compound);
            builder.unsafeNbt(compound);
        }
        return builder.build();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators() {
        return this.lazyLoadManipulatorsAndKeys();
    }

    @Nullable
    private ImmutableMap<Key<?>, Object> getKeyMap() {
        if (this.api$keyMap == null) {
            this.lazyLoadManipulatorsAndKeys();
        }
        return this.api$keyMap;
    }

    private ImmutableList<ImmutableDataManipulator<?, ?>> lazyLoadManipulatorsAndKeys() {
        if (this.api$manipulators == null) {
            this.api$manipulators = ImmutableList.copyOf(((BlockBridge)this.field_177239_a).bridge$getManipulators((IBlockState)this));
        }
        if (this.api$keyMap == null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableSet.Builder keyBuilder = ImmutableSet.builder();
            ImmutableSet.Builder valueBuilder = ImmutableSet.builder();
            for (ImmutableDataManipulator manipulator : this.api$manipulators) {
                for (ImmutableValue<?> value : manipulator.getValues()) {
                    builder.put(value.getKey(), value.get());
                    valueBuilder.add(value);
                    keyBuilder.add(value.getKey());
                }
            }
            this.api$values = valueBuilder.build();
            this.api$keys = keyBuilder.build();
            this.api$keyMap = builder.build();
        }
        return this.api$manipulators;
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> get(Class<T> containerClass) {
        for (ImmutableDataManipulator<?, ?> manipulator : this.getManipulators()) {
            if (!containerClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public <T extends ImmutableDataManipulator<?, ?>> Optional<T> getOrCreate(Class<T> containerClass) {
        for (ImmutableDataManipulator<?, ?> manipulator : this.getManipulators()) {
            if (!containerClass.isInstance(manipulator)) continue;
            return Optional.of(manipulator);
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return ((BlockBridge)this.field_177239_a).bridge$supports(containerClass);
    }

    @Override
    public <E> Optional<BlockState> transform(Key<? extends BaseValue<E>> key, Function<E, E> function) {
        return this.get((Key)Preconditions.checkNotNull(key, (Object)"Key cannot be null!")).map((Function)Preconditions.checkNotNull(function, (Object)"Function cannot be null!")).map(newVal -> this.with(key, newVal).orElse(this));
    }

    @Override
    public <E> Optional<BlockState> with(Key<? extends BaseValue<E>> key, E value) {
        if (!this.supports(key)) {
            return Optional.empty();
        }
        return ((BlockBridge)this.field_177239_a).bridge$getStateWithValue((IBlockState)this, key, value);
    }

    @Override
    public Optional<BlockState> with(BaseValue<?> value) {
        return this.with(value.getKey(), value.get());
    }

    @Override
    public Optional<BlockState> with(ImmutableDataManipulator<?, ?> valueContainer) {
        if (this.supports((Class<? extends ImmutableDataManipulator<?, ?>>)valueContainer.getClass())) {
            return ((BlockBridge)this.field_177239_a).bridge$getStateWithData((IBlockState)this, valueContainer);
        }
        return Optional.empty();
    }

    @Override
    public Optional<BlockState> with(Iterable<ImmutableDataManipulator<?, ?>> valueContainers) {
        BlockState state = this;
        for (ImmutableDataManipulator<?, ?> manipulator : valueContainers) {
            Optional optional = state.with(manipulator);
            if (optional.isPresent()) {
                state = (BlockState)optional.get();
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(state);
    }

    @Override
    public Optional<BlockState> without(Class<? extends ImmutableDataManipulator<?, ?>> containerClass) {
        return Optional.empty();
    }

    @Override
    public BlockState merge(BlockState that) {
        if (!this.getType().equals(that.getType())) {
            return this;
        }
        BlockState temp = this;
        for (ImmutableDataManipulator<?, ?> manipulator : that.getManipulators()) {
            Optional optional = temp.with(manipulator);
            if (optional.isPresent()) {
                temp = (BlockState)optional.get();
                continue;
            }
            return temp;
        }
        return temp;
    }

    @Override
    public BlockState merge(BlockState that, MergeFunction function) {
        if (!this.getType().equals(that.getType())) {
            return this;
        }
        BlockState temp = this;
        for (ImmutableDataManipulator<?, ?> manipulator : that.getManipulators()) {
            ImmutableDataManipulator old = temp.get(manipulator.getClass()).orElse(null);
            Optional optional = temp.with((ValueContainer)Preconditions.checkNotNull(function.merge(old, manipulator)));
            if (optional.isPresent()) {
                temp = (BlockState)optional.get();
                continue;
            }
            return temp;
        }
        return temp;
    }

    @Override
    public <T extends Property<?, ?>> Optional<T> getProperty(Class<T> propertyClass) {
        return Optional.ofNullable((Property)this.getSpongeInternalProperties().get(propertyClass));
    }

    @Override
    public Collection<Property<?, ?>> getApplicableProperties() {
        return this.getSpongeInternalProperties().values();
    }

    private ImmutableMap<Class<? extends Property<?, ?>>, Property<?, ?>> getSpongeInternalProperties() {
        if (this.api$dataProperties == null) {
            this.api$dataProperties = ((BlockBridge)this.field_177239_a).bridge$getProperties((IBlockState)this);
        }
        return this.api$dataProperties;
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> getContainers() {
        return this.getManipulators();
    }

    @Override
    public <E> Optional<E> get(Key<? extends BaseValue<E>> key) {
        return Optional.ofNullable(this.getKeyMap().get(key));
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> getValue(Key<V> key) {
        Preconditions.checkNotNull(key);
        for (ImmutableValue<?> value : this.getValues()) {
            if (!value.getKey().equals(key)) continue;
            return Optional.of(value.asMutable());
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(Key<?> key) {
        return this.getKeys().contains(Preconditions.checkNotNull(key));
    }

    @Override
    public BlockState copy() {
        return this;
    }

    @Override
    public Set<Key<?>> getKeys() {
        if (this.api$keys == null) {
            this.lazyLoadManipulatorsAndKeys();
        }
        return this.api$keys;
    }

    @Override
    public Set<ImmutableValue<?>> getValues() {
        if (this.api$values == null) {
            this.lazyLoadManipulatorsAndKeys();
        }
        return this.api$values;
    }

    @Override
    public int getContentVersion() {
        return 2;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Constants.Block.BLOCK_STATE, (Object)this.getId());
    }

    @Override
    public String getId() {
        if (this.api$id == null) {
            this.impl$generateIdFromParentBlock(this.field_177239_a);
        }
        return this.api$id;
    }

    @Override
    public String getName() {
        if (this.api$id == null) {
            this.impl$generateIdFromParentBlock(this.field_177239_a);
        }
        return this.api$id;
    }

    private void impl$generateIdFromParentBlock(Block block) {
        StringBuilder builder = new StringBuilder();
        builder.append(((BlockType)block).getId());
        if (!this.field_177237_b.isEmpty()) {
            builder.append('[');
            Joiner joiner = Joiner.on((char)',');
            ArrayList<String> propertyValues = new ArrayList<String>();
            for (Map.Entry entry : this.field_177237_b.entrySet()) {
                Comparable value = (Comparable)entry.getValue();
                String stringValue = value instanceof IStringSerializable ? ((IStringSerializable)value).func_176610_l() : value.toString();
                propertyValues.add(((IProperty)entry.getKey()).func_177701_a() + "=" + stringValue);
            }
            builder.append(joiner.join(propertyValues));
            builder.append(']');
        }
        this.api$id = builder.toString();
    }
}

