/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.enchantment;

import com.google.common.base.Objects;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.item.enchantment.Enchantment;
import org.spongepowered.api.item.enchantment.EnchantmentType;

public final class SpongeEnchantment
implements Enchantment {
    private final EnchantmentType enchantmentType;
    private final int level;

    public SpongeEnchantment(EnchantmentType enchantmentType, int level) {
        this.enchantmentType = enchantmentType;
        this.level = level;
    }

    @Override
    public EnchantmentType getType() {
        return this.enchantmentType;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(Queries.ENCHANTMENT_ID, (Object)this.enchantmentType.getId()).set(Queries.LEVEL, (Object)this.level);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enchantmentType, this.level});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SpongeEnchantment other = (SpongeEnchantment)object;
        return Objects.equal((Object)this.enchantmentType, (Object)other.enchantmentType) && Objects.equal((Object)this.level, (Object)other.level);
    }
}

