/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Chunk;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.BlockEventDataBridge;
import org.spongepowered.common.bridge.server.management.PlayerChunkMapEntryBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.BlockTransaction;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.NeighborNotificationContext;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public interface IPhaseState<C extends PhaseContext<C>> {
    public static final BiConsumer<CauseStackManager.StackFrame, ? extends PhaseContext<?>> DEFAULT_OWNER_NOTIFIER = (frame, ctx) -> {
        if (ctx.usedFrame == null) {
            ctx.usedFrame = new ArrayDeque<CauseStackManager.StackFrame>();
        }
        ctx.usedFrame.push((CauseStackManager.StackFrame)frame);
        if (ctx.owner != null) {
            frame.addContext(EventContextKeys.OWNER, ctx.owner);
        }
        if (ctx.notifier != null) {
            frame.addContext(EventContextKeys.NOTIFIER, ctx.notifier);
        }
    };

    public C createPhaseContext();

    default public BiConsumer<CauseStackManager.StackFrame, C> getFrameModifier() {
        return DEFAULT_OWNER_NOTIFIER;
    }

    default public boolean isNotReEntrant() {
        return true;
    }

    default public boolean isInteraction() {
        return false;
    }

    default public boolean isTicking() {
        return false;
    }

    default public boolean isWorldGeneration() {
        return false;
    }

    default public boolean includesDecays() {
        return false;
    }

    default public boolean isEvent() {
        return false;
    }

    public void unwind(C var1);

    default public boolean spawnEntityOrCapture(C context, Entity entity, int chunkX, int chunkZ) {
        ArrayList<Entity> entities = new ArrayList<Entity>(1);
        entities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.PASSIVE);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(entities, context);
            return bl;
        }
    }

    default public boolean spawnItemOrCapture(C phaseContext, net.minecraft.entity.Entity entity, EntityItem entityitem) {
        if (this.doesCaptureEntityDrops(phaseContext)) {
            if (this.tracksEntitySpecificDrops()) {
                SpongeImplHooks.capturePerEntityItemDrop(phaseContext, entity, entityitem);
            } else {
                ((PhaseContext)phaseContext).getCapturedItemsSupplier().get().add(entityitem);
            }
            return true;
        }
        return false;
    }

    default public void performOnBlockAddedSpawns(C context, int depth) {
    }

    default public void performPostBlockNotificationsAndNeighborUpdates(C context, IBlockState newState, SpongeBlockChangeFlag changeFlag, int currentDepth) {
    }

    default public ChangeBlockEvent.Post createChangeBlockPostEvent(C context, ImmutableList<Transaction<BlockSnapshot>> transactions, Cause cause) {
        return SpongeEventFactory.createChangeBlockEventPost(cause, transactions);
    }

    default public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> snapshotTransaction, C context) {
    }

    default public void postProcessSpawns(C unwindingContext, ArrayList<Entity> entities) {
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            SpongeCommonEventFactory.callSpawnEntity(entities, unwindingContext);
        }
    }

    default public boolean tracksOwnersAndNotifiers() {
        return true;
    }

    default public boolean tracksBlockSpecificDrops(C context) {
        return false;
    }

    default public boolean tracksEntitySpecificDrops() {
        return false;
    }

    default public boolean tracksEntityDeaths() {
        return false;
    }

    default public boolean doesCaptureEntityDrops(C context) {
        return false;
    }

    default public boolean doesAllowEntitySpawns() {
        return true;
    }

    default public boolean doesBulkBlockCapture(C context) {
        return true;
    }

    default public boolean doesDenyChunkRequests() {
        return false;
    }

    default public boolean doesCaptureEntitySpawns() {
        return false;
    }

    default public boolean doesBlockEventTracking(C context) {
        return true;
    }

    default public boolean doesDropEventTracking(C context) {
        return true;
    }

    default public boolean ignoresEntityCollisions() {
        return false;
    }

    default public boolean ignoresBlockEvent() {
        return false;
    }

    default public boolean ignoresBlockUpdateTick(C context) {
        return false;
    }

    default public boolean ignoresScheduledUpdates() {
        return false;
    }

    default public boolean ignoresItemPreMerging() {
        return false;
    }

    default public boolean shouldCaptureBlockChangeOrSkip(C phaseContext, BlockPos pos, IBlockState currentState, IBlockState newState, BlockChangeFlag flags) {
        return true;
    }

    default public boolean alreadyCapturingBlockTicks(C context) {
        return false;
    }

    default public boolean alreadyCapturingEntitySpawns() {
        return false;
    }

    default public boolean alreadyCapturingEntityTicks() {
        return false;
    }

    default public boolean alreadyCapturingTileTicks() {
        return false;
    }

    default public boolean alreadyProcessingBlockItemDrops() {
        return false;
    }

    default public boolean requiresBlockPosTracking() {
        return false;
    }

    default public boolean requiresPost() {
        return true;
    }

    default public boolean handlesOwnStateCompletion() {
        return false;
    }

    default public void associateNeighborStateNotifier(C unwindingContext, @Nullable BlockPos sourcePos, Block block, BlockPos notifyPos, WorldServer minecraftWorld, PlayerTracker.Type notifier) {
    }

    default public void appendContextPreExplosion(ExplosionContext explosionContext, C currentPhaseData) {
    }

    default public void appendNotifierPreBlockTick(WorldServerBridge mixinWorld, BlockPos pos, C context, BlockTickContext phaseContext) {
        net.minecraft.world.chunk.Chunk chunk = ((WorldServer)mixinWorld).func_175726_f(pos);
        ChunkBridge mixinChunk = (ChunkBridge)chunk;
        if (chunk != null && !chunk.func_76621_g()) {
            mixinChunk.bridge$getBlockOwner(pos).ifPresent(phaseContext::owner);
            mixinChunk.bridge$getBlockNotifier(pos).ifPresent(phaseContext::notifier);
        }
    }

    default public void appendNotifierToBlockEvent(C context, PhaseContext<?> currentContext, WorldServerBridge mixinWorldServer, BlockPos pos, BlockEventDataBridge blockEvent) {
    }

    default public void capturePlayerUsingStackToBreakBlock(ItemStack itemStack, EntityPlayerMP playerIn, C context) {
    }

    default public void provideNotifierForNeighbors(C context, NeighborNotificationContext notification) {
        if (((PhaseContext)context).neighborNotificationSource != null) {
            notification.setSourceNotification(((PhaseContext)context).neighborNotificationSource);
        }
        if (((PhaseContext)context).notifier != null) {
            notification.notifier(((PhaseContext)context).notifier);
            return;
        }
        if (((PhaseContext)context).owner != null) {
            notification.notifier(((PhaseContext)context).owner);
        }
    }

    default public boolean allowsEventListener() {
        return true;
    }

    default public Vector3i getChunkPopulatorOffset(Chunk chunk, int chunkX, int chunkZ) {
        return new Vector3i(chunkX * 16 + 8, 0, chunkZ * 16 + 8);
    }

    default public boolean isRegeneration() {
        return false;
    }

    default public boolean getShouldCancelAllTransactions(C context, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent, ListMultimap<BlockPos, BlockEventData> scheduledEvents, boolean noCancelledTransactions) {
        return false;
    }

    @Nullable
    default public BlockTransaction.ChangeBlock captureBlockChange(C phaseContext, BlockPos pos, SpongeBlockSnapshot originalBlockSnapshot, IBlockState newState, BlockChangeFlag flags, @Nullable TileEntity tileEntity) {
        if (!this.doesBulkBlockCapture(phaseContext)) {
            ((PhaseContext)phaseContext).setSingleSnapshot(originalBlockSnapshot);
            return null;
        }
        if (this.hasSpecificBlockProcess(phaseContext)) {
            return ((PhaseContext)phaseContext).getCapturedBlockSupplier().logBlockChange(originalBlockSnapshot, newState, flags);
        }
        ((PhaseContext)phaseContext).getCapturedBlockSupplier().put(originalBlockSnapshot, newState);
        return null;
    }

    default public boolean tracksTileEntityChanges(C currentContext) {
        return false;
    }

    default public void processCancelledTransaction(C context, Transaction<BlockSnapshot> transaction, BlockSnapshot original) {
        if (this.hasSpecificBlockProcess(context)) {
            ((PhaseContext)context).getCapturedBlockSupplier().cancelTransaction(original);
            ((SpongeBlockSnapshot)original).getWorldServer().ifPresent(worldServer -> {
                net.minecraft.world.chunk.Chunk chunk = worldServer.func_175726_f(((SpongeBlockSnapshot)original).getBlockPos());
                PlayerChunkMapEntry entry = worldServer.func_184164_w().func_187301_b(chunk.field_76635_g, chunk.field_76647_h);
                if (entry != null) {
                    ((PlayerChunkMapEntryBridge)entry).bridge$markBiomesForUpdate();
                }
            });
        }
        if (this.tracksBlockSpecificDrops(context) && transaction.getOriginal() instanceof SpongeBlockSnapshot) {
            BlockPos pos = ((SpongeBlockSnapshot)transaction.getOriginal()).getBlockPos();
            ((PhaseContext)context).getBlockDropSupplier().removeAllIfNotEmpty(pos);
        }
    }

    default public boolean hasSpecificBlockProcess(C context) {
        return false;
    }

    default public boolean doesCaptureNeighborNotifications(C context) {
        return false;
    }

    default public void postProcessSpecificBlockChange(C currentContext, BlockTransaction.ChangeBlock changeBlock, int i) {
    }

    default public BlockChange associateBlockChangeWithSnapshot(C phaseContext, IBlockState newState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        if (newBlock == Blocks.field_150350_a) {
            return BlockChange.BREAK;
        }
        if (newBlock != originalBlock && !TrackingUtil.forceModify(originalBlock, newBlock)) {
            return BlockChange.PLACE;
        }
        return BlockChange.MODIFY;
    }

    default public boolean shouldProvideModifiers(C phaseContext) {
        return true;
    }

    default public boolean isRestoring() {
        return false;
    }

    default public boolean isConvertingMaps() {
        return false;
    }

    default public boolean allowsGettingQueuedRemovedTiles() {
        return false;
    }

    default public void markTeleported(C phaseContext) {
    }
}

