/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.value.entity;

import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.data.processor.common.AbstractSpongeValueProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class EntityDisplayNameValueProcessor
extends AbstractSpongeValueProcessor<Entity, Text, Value<Text>> {
    public EntityDisplayNameValueProcessor() {
        super(Entity.class, Keys.DISPLAY_NAME);
    }

    @Override
    protected Value<Text> constructValue(Text actualValue) {
        return new SpongeValue<Text>(this.key, Text.of(), actualValue);
    }

    @Override
    protected boolean set(Entity container, Text value) {
        ((EntityBridge)container).bridge$setDisplayName(value);
        return true;
    }

    @Override
    protected Optional<Text> getVal(Entity container) {
        return Optional.ofNullable(((EntityBridge)container).bridge$getDisplayNameText());
    }

    @Override
    protected ImmutableValue<Text> constructImmutableValue(Text value) {
        return new ImmutableSpongeValue<Text>(this.key, Text.of(), value);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        Optional optional = this.getValueFromContainer(container);
        if (optional.isPresent()) {
            try {
                ((EntityBridge)((Object)container)).bridge$setDisplayName(null);
                return builder.replace(new ImmutableSpongeValue(this.key, optional.get())).result(DataTransactionResult.Type.SUCCESS).build();
            }
            catch (Exception e) {
                SpongeImpl.getLogger().error("There was an issue resetting the display name on an entity!", (Throwable)e);
                return builder.result(DataTransactionResult.Type.ERROR).build();
            }
        }
        return builder.result(DataTransactionResult.Type.SUCCESS).build();
    }
}

