/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.item;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableDyeableData;
import org.spongepowered.api.data.manipulator.mutable.DyeableData;
import org.spongepowered.api.data.type.DyeColor;
import org.spongepowered.api.data.type.DyeColors;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.SpongeDyeableData;
import org.spongepowered.common.data.processor.common.AbstractItemSingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;

public class ItemDyeColorDataProcessor
extends AbstractItemSingleDataProcessor<DyeColor, Value<DyeColor>, DyeableData, ImmutableDyeableData> {
    public ItemDyeColorDataProcessor() {
        super((ItemStack x) -> ItemDyeColorDataProcessor.isDyeable(x.func_77973_b()), Keys.DYE_COLOR);
    }

    public static boolean isDyeable(Item item) {
        if (item.equals(Items.field_151100_aR) || item.equals(Items.field_151104_aV)) {
            return true;
        }
        Block block = Block.func_149634_a((Item)item);
        return block.equals(Blocks.field_150325_L) || block.equals(Blocks.field_180393_cK) || block.equals(Blocks.field_150399_cn) || block.equals(Blocks.field_150404_cg) || block.equals(Blocks.field_150397_co) || block.equals(Blocks.field_150406_ce) || block.equals(Blocks.field_192443_dR) || block.equals(Blocks.field_192444_dS);
    }

    @Override
    protected Value<DyeColor> constructValue(DyeColor actualValue) {
        return SpongeValueFactory.getInstance().createValue(Keys.DYE_COLOR, actualValue, DyeColors.BLACK);
    }

    @Override
    protected boolean set(ItemStack container, DyeColor value) {
        Item item = container.func_77973_b();
        if (item.equals(Items.field_151100_aR) || item.equals(Items.field_179564_cE)) {
            container.func_77964_b(((EnumDyeColor)value).func_176767_b());
        } else {
            container.func_77964_b(((EnumDyeColor)value).func_176765_a());
        }
        return true;
    }

    @Override
    protected Optional<DyeColor> getVal(ItemStack container) {
        Item item = container.func_77973_b();
        if (item.equals(Items.field_151100_aR) || item.equals(Items.field_179564_cE)) {
            return Optional.of((DyeColor)EnumDyeColor.func_176766_a((int)container.func_77952_i()));
        }
        return Optional.of((DyeColor)EnumDyeColor.func_176764_b((int)container.func_77952_i()));
    }

    @Override
    protected ImmutableValue<DyeColor> constructImmutableValue(DyeColor value) {
        return this.constructValue(value).asImmutable();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected DyeableData createManipulator() {
        return new SpongeDyeableData();
    }
}

