/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.gson;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.loader.AbstractConfigurationLoader;
import ninja.leaping.configurate.loader.CommentHandler;
import ninja.leaping.configurate.loader.CommentHandlers;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GsonConfigurationLoader
extends AbstractConfigurationLoader<ConfigurationNode> {
    private final boolean lenient;
    private final String indent;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    private GsonConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{CommentHandlers.DOUBLE_SLASH, CommentHandlers.SLASH_BLOCK, CommentHandlers.HASH});
        this.lenient = builder.isLenient();
        this.indent = Strings.repeat((String)" ", (int)builder.getIndent());
    }

    @Override
    protected void loadInternal(ConfigurationNode node, BufferedReader reader) throws IOException {
        reader.mark(1);
        if (reader.read() == -1) {
            return;
        }
        reader.reset();
        try (JsonReader parser = new JsonReader((Reader)reader);){
            parser.setLenient(this.lenient);
            this.parseValue(parser, node);
        }
    }

    private void parseValue(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token = parser.peek();
        switch (token) {
            case BEGIN_OBJECT: {
                this.parseObject(parser, node);
                break;
            }
            case BEGIN_ARRAY: {
                this.parseArray(parser, node);
                break;
            }
            case NUMBER: {
                double nextDouble = parser.nextDouble();
                int nextInt = (int)nextDouble;
                long nextLong = (long)nextDouble;
                if ((double)nextInt == nextDouble) {
                    node.setValue(nextInt);
                    break;
                }
                if ((double)nextLong == nextDouble) {
                    node.setValue(nextLong);
                    break;
                }
                node.setValue(nextDouble);
                break;
            }
            case STRING: {
                node.setValue(parser.nextString());
                break;
            }
            case BOOLEAN: {
                node.setValue(parser.nextBoolean());
                break;
            }
            case NULL: 
            case NAME: {
                break;
            }
            default: {
                throw new IOException("Unsupported token type: " + token);
            }
        }
    }

    private void parseArray(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginArray();
        while ((token = parser.peek()) != null) {
            switch (token) {
                case END_ARRAY: {
                    parser.endArray();
                    return;
                }
            }
            this.parseValue(parser, node.getAppendedNode());
        }
        throw new JsonParseException("Reached end of stream with unclosed array at!");
    }

    private void parseObject(JsonReader parser, ConfigurationNode node) throws IOException {
        JsonToken token;
        parser.beginObject();
        block4: while ((token = parser.peek()) != null) {
            switch (token) {
                case END_OBJECT: 
                case END_DOCUMENT: {
                    parser.endObject();
                    return;
                }
                case NAME: {
                    this.parseValue(parser, node.getNode(parser.nextName()));
                    continue block4;
                }
            }
            throw new JsonParseException("Received improper object value " + token);
        }
        throw new JsonParseException("Reached end of stream with unclosed object!");
    }

    @Override
    public void saveInternal(ConfigurationNode node, Writer writer) throws IOException {
        if (!this.lenient && !node.hasMapChildren()) {
            throw new IOException("Non-lenient json generators must have children of map type");
        }
        try (JsonWriter generator = new JsonWriter(writer);){
            generator.setIndent(this.indent);
            generator.setLenient(this.lenient);
            GsonConfigurationLoader.generateValue(generator, node);
            generator.flush();
            writer.write(SYSTEM_LINE_SEPARATOR);
        }
    }

    @Override
    public @NonNull ConfigurationNode createEmptyNode(@NonNull ConfigurationOptions options) {
        options = options.setAcceptedTypes((Set<Class<?>>)ImmutableSet.of(Map.class, List.class, Double.class, Float.class, Long.class, Integer.class, (Object[])new Class[]{Boolean.class, String.class}));
        return SimpleConfigurationNode.root(options);
    }

    private static void generateValue(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (node.hasMapChildren()) {
            GsonConfigurationLoader.generateObject(generator, node);
        } else if (node.hasListChildren()) {
            GsonConfigurationLoader.generateArray(generator, node);
        } else if (node.getKey() == null && node.getValue() == null) {
            generator.beginObject();
            generator.endObject();
        } else {
            Object value = node.getValue();
            if (value instanceof Double) {
                generator.value((Number)((Double)value));
            } else if (value instanceof Float) {
                generator.value((Number)((Float)value));
            } else if (value instanceof Long) {
                generator.value((Number)((Long)value));
            } else if (value instanceof Integer) {
                generator.value((Number)((Integer)value));
            } else if (value instanceof Boolean) {
                generator.value((Boolean)value);
            } else {
                generator.value(value.toString());
            }
        }
    }

    private static void generateObject(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (!node.hasMapChildren()) {
            throw new IOException("Node passed to generateObject does not have map children!");
        }
        generator.beginObject();
        for (Map.Entry<Object, ? extends ConfigurationNode> ent : node.getChildrenMap().entrySet()) {
            generator.name(ent.getKey().toString());
            GsonConfigurationLoader.generateValue(generator, ent.getValue());
        }
        generator.endObject();
    }

    private static void generateArray(JsonWriter generator, ConfigurationNode node) throws IOException {
        if (!node.hasListChildren()) {
            throw new IOException("Node passed to generateArray does not have list children!");
        }
        List<? extends ConfigurationNode> children = node.getChildrenList();
        generator.beginArray();
        for (ConfigurationNode configurationNode : children) {
            GsonConfigurationLoader.generateValue(generator, configurationNode);
        }
        generator.endArray();
    }

    public static class Builder
    extends AbstractConfigurationLoader.Builder<Builder> {
        private boolean lenient = true;
        private int indent = 2;

        protected Builder() {
        }

        public @NonNull Builder setIndent(int indent) {
            this.indent = indent;
            return this;
        }

        public int getIndent() {
            return this.indent;
        }

        public @NonNull Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        @Override
        public @NonNull GsonConfigurationLoader build() {
            return new GsonConfigurationLoader(this);
        }
    }
}

