/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.common.item.ItemGlyph;

public class GlyphPlacementGridRenderer {
    private static final double MARKER_SIZE_PX = 8.0;
    private static final double MARKER_SIZE = 0.5;
    private static final double GRID_STEP_PX = 1.0;
    private static final double GRID_STEP = 0.0625;
    private final Map<EnumFacing.Axis, AxisElements> elements = GlyphPlacementGridRenderer.generateElements();

    private static Vertex vertex(Vec3d v) {
        return new Vertex(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    private static List<Vertex> generateGrid(Vec3d firstAxis, Vec3d secondAxis) {
        ImmutableList.Builder builder = ImmutableList.builder();
        GlyphPlacementGridRenderer.generateGridLines((ImmutableList.Builder<Vertex>)builder, firstAxis, secondAxis);
        GlyphPlacementGridRenderer.generateGridLines((ImmutableList.Builder<Vertex>)builder, secondAxis, firstAxis);
        return builder.build();
    }

    private static void generateGridLines(ImmutableList.Builder<Vertex> builder, Vec3d firstAxis, Vec3d secondAxis) {
        Vec3d start = Vec3d.field_186680_a;
        Vec3d end = firstAxis;
        Vec3d step = secondAxis.func_186678_a(0.0625);
        for (int i = 0; i < 16; ++i) {
            builder.add((Object)GlyphPlacementGridRenderer.vertex(start));
            builder.add((Object)GlyphPlacementGridRenderer.vertex(end));
            start = start.func_178787_e(step);
            end = end.func_178787_e(step);
        }
        builder.add((Object)GlyphPlacementGridRenderer.vertex(start));
        builder.add((Object)GlyphPlacementGridRenderer.vertex(end));
    }

    private static List<Vertex> generateMarker(Vec3d firstAxis, Vec3d secondAxis) {
        Vec3d va = firstAxis.func_186678_a(0.5);
        Vec3d vb = secondAxis.func_186678_a(0.5);
        Vertex a = GlyphPlacementGridRenderer.vertex(va);
        Vertex b = GlyphPlacementGridRenderer.vertex(vb);
        Vertex ab = GlyphPlacementGridRenderer.vertex(va.func_178787_e(vb));
        return ImmutableList.of((Object)Vertex.ZERO, (Object)a, (Object)ab, (Object)b, (Object)Vertex.ZERO, (Object)b, (Object)ab, (Object)a);
    }

    private static Map<EnumFacing.Axis, AxisElements> generateElements() {
        EnumMap<EnumFacing.Axis, AxisElements> result = new EnumMap<EnumFacing.Axis, AxisElements>(EnumFacing.Axis.class);
        Vec3d axisX = new Vec3d(1.0, 0.0, 0.0);
        Vec3d axisY = new Vec3d(0.0, 1.0, 0.0);
        Vec3d axisZ = new Vec3d(0.0, 0.0, 1.0);
        result.put(EnumFacing.Axis.X, new AxisElements(axisX, axisY, axisZ));
        result.put(EnumFacing.Axis.Y, new AxisElements(axisY, axisX, axisZ));
        result.put(EnumFacing.Axis.Z, new AxisElements(axisZ, axisX, axisY));
        return Collections.unmodifiableMap(result);
    }

    @SubscribeEvent
    public void onHighlightDraw(DrawBlockHighlightEvent evt) {
        EntityPlayer player;
        RayTraceResult target = evt.getTarget();
        if (target != null && target.field_72313_a == RayTraceResult.Type.BLOCK && (player = evt.getPlayer()).func_184614_ca().func_77973_b() instanceof ItemGlyph) {
            this.drawGrid(player, target, evt.getPartialTicks());
        }
    }

    private static double calculateGridCoordinate(double v, double selector) {
        return selector * Math.floor(v * 16.0 - 4.0) / 16.0;
    }

    private void drawGrid(EntityPlayer player, RayTraceResult target, float partialTicks) {
        EnumFacing side = target.field_178784_b;
        if (side.func_176740_k() == EnumFacing.Axis.Y) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        Vec3d posD = new Vec3d((Vec3i)pos);
        Vec3d hitRel = target.field_72307_f.func_178788_d(posD);
        double dx = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double dy = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double dz = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        AxisElements e = this.elements.get(side.func_176740_k());
        Vec3d normalDist = new Vec3d(hitRel.field_72450_a * ((AxisElements)e).normal.field_72450_a, hitRel.field_72448_b * ((AxisElements)e).normal.field_72448_b, hitRel.field_72449_c * ((AxisElements)e).normal.field_72449_c);
        Vec3d gridOrigin = new Vec3d(GlyphPlacementGridRenderer.calculateGridCoordinate(hitRel.field_72450_a, ((AxisElements)e).proj.field_72450_a), GlyphPlacementGridRenderer.calculateGridCoordinate(hitRel.field_72448_b, ((AxisElements)e).proj.field_72448_b), GlyphPlacementGridRenderer.calculateGridCoordinate(hitRel.field_72449_c, ((AxisElements)e).proj.field_72449_c));
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179136_a((float)-3.0f, (float)-3.0f);
        GlStateManager.func_179088_q();
        double blockOriginX = posD.field_72450_a - dx + normalDist.field_72450_a;
        double blockOriginY = posD.field_72448_b - dy + normalDist.field_72448_b;
        double blockOriginZ = posD.field_72449_c - dz + normalDist.field_72449_c;
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder builder = t.func_178180_c();
        builder.func_178969_c(blockOriginX, blockOriginY, blockOriginZ);
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        e.drawGrid(builder);
        t.func_78381_a();
        builder.func_178969_c(blockOriginX + gridOrigin.field_72450_a, blockOriginY + gridOrigin.field_72448_b, blockOriginZ + gridOrigin.field_72449_c);
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        e.drawMarker(builder);
        t.func_78381_a();
        builder.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179113_r();
    }

    private static class AxisElements {
        private final Vec3d normal;
        private final Vec3d proj;
        private final List<Vertex> grid;
        private final List<Vertex> marker;

        public AxisElements(Vec3d normal, Vec3d pA, Vec3d pB) {
            this.normal = normal;
            this.proj = pA.func_178787_e(pB);
            this.grid = GlyphPlacementGridRenderer.generateGrid(pA, pB);
            this.marker = GlyphPlacementGridRenderer.generateMarker(pA, pB);
        }

        public void drawGrid(BufferBuilder builder) {
            for (Vertex v : this.grid) {
                v.draw(builder);
            }
        }

        public void drawMarker(BufferBuilder builder) {
            for (Vertex v : this.marker) {
                v.draw(builder);
            }
        }
    }

    private static class Vertex {
        public static final Vertex ZERO = new Vertex(0.0, 0.0, 0.0);
        private final double x;
        private final double y;
        private final double z;

        public Vertex(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        void draw(BufferBuilder builder) {
            builder.func_181662_b(this.x, this.y, this.z).func_181666_a(0.5f, 0.5f, 0.5f, 0.5f).func_181675_d();
        }
    }
}

