/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.helper;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockFinder {
    private BlockPos pos;
    private final World worldObj;

    public BlockFinder(BlockPos pos, World worldObj) {
        this.pos = pos;
        this.worldObj = worldObj;
    }

    public List<BlockPos> getSurroundingBlockPos(BlockPos pos, Block targetBlock) {
        List<BlockPos> posList = BlockFinder.getFacingList().stream().filter(facing -> this.isTargetBlock(pos, (EnumFacing)facing, targetBlock)).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).collect(Collectors.toList());
        return posList;
    }

    public List<BlockPos> getSurroundingTileEntityPos(BlockPos pos) {
        List<BlockPos> posList = BlockFinder.getFacingList().stream().filter(facing -> this.isTileEntityBlock(pos, (EnumFacing)facing)).map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).collect(Collectors.toList());
        return posList;
    }

    public List<Block> getSurroundingBlockList(Block targetBlock) {
        List<Block> blocks = BlockFinder.getFacingList().stream().map(this::getBlock).filter(block -> block == targetBlock).collect(Collectors.toList());
        return blocks;
    }

    public int getSurroundingTargetBlockAmount(Block targetBlock) {
        int amount = 0;
        List<Block> blocks = this.getAllAroundBlocks();
        amount = blocks.stream().filter(block -> block == targetBlock).collect(Collectors.toList()).size();
        return amount;
    }

    private List<Block> getAllAroundBlocks() {
        List<Block> blocks = BlockFinder.getFacingList().stream().map(this::getBlock).collect(Collectors.toList());
        return blocks;
    }

    private Block getBlock(EnumFacing facing) {
        BlockPos pos = this.pos.func_177972_a(facing);
        return this.getBlock(pos);
    }

    private Block getBlock(BlockPos pos) {
        Block block = this.worldObj.func_180495_p(pos).func_177230_c();
        return block;
    }

    private boolean isTargetBlock(BlockPos pos, EnumFacing f, Block targetBlock) {
        return this.getBlock(pos, f) == targetBlock;
    }

    private boolean isTileEntityBlock(BlockPos pos, EnumFacing f) {
        return this.worldObj.func_175625_s(pos) != null;
    }

    private Block getBlock(BlockPos pos, EnumFacing facing) {
        return this.getBlock(pos.func_177972_a(facing));
    }

    public static List<EnumFacing> getFacingList() {
        List<EnumFacing> facings = Arrays.asList(EnumFacing.field_82609_l);
        return facings;
    }

    public static List<BlockPos> getAllAmountBlockPosList(BlockPos pos) {
        List<BlockPos> posList = BlockFinder.getFacingList().stream().map(arg_0 -> ((BlockPos)pos).func_177972_a(arg_0)).collect(Collectors.toList());
        return posList;
    }
}

